/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.Arrays;
import org.zeromq.ZMQ;

public class ZFrame {
    private boolean more;
    private byte[] data;

    protected ZFrame() {
    }

    public ZFrame(byte[] data) {
        if (data != null) {
            this.data = (byte[])data.clone();
        }
    }

    public ZFrame(String data) {
        if (data != null) {
            this.data = data.getBytes();
        }
    }

    public void destroy() {
        if (this.hasData()) {
            this.data = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasMore() {
        return this.more;
    }

    public int size() {
        if (this.hasData()) {
            return this.data.length;
        }
        return 0;
    }

    public boolean hasData() {
        return this.data != null;
    }

    private boolean send(ZMQ.Socket socket, int flags) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must be set");
        }
        if (!this.hasData()) {
            throw new IllegalAccessError("Cannot send frame without data");
        }
        return socket.send(this.data, flags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket, int flags) {
        return this.send(socket, flags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket) {
        return this.sendAndKeep(socket, 0);
    }

    public boolean sendAndDestroy(ZMQ.Socket socket, int flags) {
        boolean ret = this.send(socket, flags);
        if (ret) {
            this.destroy();
        }
        return ret;
    }

    public boolean sendAndDestroy(ZMQ.Socket socket) {
        return this.sendAndDestroy(socket, 0);
    }

    public ZFrame duplicate() {
        return new ZFrame((byte[])this.data.clone());
    }

    public boolean hasSameData(ZFrame other) {
        if (other == null) {
            return false;
        }
        if (this.size() == other.size() && this.hasData() && other.hasData()) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.data[i] == other.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void reset(byte[] data) {
        this.data = data;
    }

    public String strhex() {
        String hexChar = "0123456789ABCDEF";
        StringBuilder b = new StringBuilder();
        for (int nbr = 0; nbr < this.data.length; ++nbr) {
            int b1 = this.data[nbr] >>> 4 & 0xF;
            int b2 = this.data[nbr] & 0xF;
            b.append(hexChar.charAt(b1));
            b.append(hexChar.charAt(b2));
        }
        return b.toString();
    }

    public boolean streq(String str) {
        if (!this.hasData()) {
            return false;
        }
        return new String(this.data).compareTo(str) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZFrame zFrame = (ZFrame)o;
        return Arrays.equals(this.data, zFrame.data);
    }

    public int hashCode() {
        return this.data != null ? Arrays.hashCode(this.data) : 0;
    }

    public String toString() {
        if (!this.hasData()) {
            return null;
        }
        boolean isText = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] >= 32 && this.data[i] <= 127) continue;
            isText = false;
        }
        if (isText) {
            return new String(this.data);
        }
        return this.strhex();
    }

    private byte[] recv(ZMQ.Socket socket, int flags) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must not be null");
        }
        this.data = socket.recv(flags);
        this.more = socket.hasReceiveMore();
        return this.data;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket) {
        ZFrame f = new ZFrame();
        f.recv(socket, 0);
        return f;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket, int flags) {
        ZFrame f = new ZFrame();
        f.recv(socket, flags);
        return f;
    }
}

