/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZContext {
    private ZMQ.Context context = null;
    private List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private int ioThreads = 1;
    private int linger = 0;
    private boolean main = true;

    public void destroy() {
        ListIterator<ZMQ.Socket> itr = this.sockets.listIterator();
        while (itr.hasNext()) {
            this.destroySocket(itr.next());
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
        }
    }

    public ZMQ.Socket createSocket(int type) {
        if (this.context == null) {
            this.context = ZMQ.context(this.ioThreads);
        }
        ZMQ.Socket socket = this.context.socket(type);
        this.sockets.add(socket);
        return socket;
    }

    public void destroySocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        if (this.sockets.contains(s)) {
            block4: {
                try {
                    s.setLinger(this.linger);
                }
                catch (ZMQException e) {
                    if ((long)e.getErrorCode() == ZMQ.ETERM()) break block4;
                    throw e;
                }
            }
            s.close();
            this.sockets.remove(s);
        }
    }

    public static ZContext shadow(ZContext ctx) {
        ZContext shadow = new ZContext();
        shadow.setContext(ctx.getContext());
        shadow.setMain(false);
        return shadow;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    public void setContext(ZMQ.Context ctx) {
        this.context = ctx;
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }
}

