/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jzmq;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.zeromq.ZMQ;
import org.zeromq.api.Context;
import org.zeromq.api.ReceiveFlag;
import org.zeromq.api.SendFlag;
import org.zeromq.api.Socket;
import org.zeromq.api.SocketType;
import org.zeromq.jzmq.ManagedContext;
import org.zeromq.jzmq.sockets.SocketBuilder;

public class ManagedSocket
implements Socket {
    private final SocketType socketType;
    private final long lingerMS;
    private final long sendHWM;
    private final long recvHWM;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private ManagedContext managedContext;
    private ZMQ.Socket socket;

    public ManagedSocket(ManagedContext managedContext, SocketBuilder builder) {
        if (builder.getSocketType() == null) {
            throw new IllegalArgumentException("SocketType cannot be null");
        }
        if (managedContext == null) {
            throw new IllegalArgumentException("ManagedContext cannot be null");
        }
        this.managedContext = managedContext;
        this.lingerMS = builder.getLinger();
        this.sendHWM = builder.getSendHWM();
        this.recvHWM = builder.getRecvHWM();
        this.socketType = builder.getSocketType();
    }

    @Override
    public ZMQ.Socket getZMQSocket() {
        return this.socket;
    }

    @Override
    public boolean isActive() {
        return !this.isClosed.get();
    }

    @Override
    public byte[] receive() throws Exception {
        return this.socket.recv(0);
    }

    @Override
    public byte[] receive(ReceiveFlag flag) throws Exception {
        return this.socket.recv(flag.getFlag());
    }

    @Override
    public void send(byte[] buf) throws Exception {
        this.send(buf, 0, SendFlag.NONE);
    }

    @Override
    public void send(byte[] buf, int offset, SendFlag flag) throws Exception {
        this.socket.send(buf, offset, flag.getFlag());
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.managedContext.destroySocket(this);
        }
    }

    @Override
    public Context getContext() {
        return this.managedContext;
    }
}

