(ns clj-web.util
  (:require [ring.core.protocols :refer [StreamableResponseBody]]))

(def p
  "A more compact spelling of 'partial'."
  partial)

(defn ring-response-map?
  "Predicate to test whether a value is a valid Ring Response Map.
   https://github.com/ring-clojure/ring/blob/master/SPEC"
  [m]
  (and (map? m)
       (contains? m :status)
       (>= (:status m) 100)
       (contains? m :headers)
       (map? (:headers m))
       (if (contains? m :body)
         (satisfies? StreamableResponseBody (:body m))
         true)))

(defn vec*
  "Coerces its argument into a new vector. Unlike the builtin vec, accepts
   non-collection types as argument (creating a vector of just that item)."
  [x]
  (if (coll? x)
    (vec x)
    [x]))
