(ns clj-web.response
  "Clj-web prefers specific intent over magic inference. Route handler
   functions are therefore required to return valid Ring Response Maps.
   This module contains convenience functions to help you create valid
   and correct responses for when the Ring's built-in utilities are
   insufficient.")

(defn not-found
  "404 Not Found"
  []
  {:status 404
   :headers {"Content-Type" "text/plain"}
   :body "Not Found"})

(defn method-not-allowed
  "405 Method Not Allowed"
  []
  {:status 405
   :headers {"Content-Type" "text/plain"}
   :body "Method Not Allowed"})
