/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.nnidentifier.network.Network;
import com.zarkonnen.longan.nnidentifier.network.Weight;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;

public class Visualizer {
    static final int W = 1000;
    static final int H = 600;
    static final Color CONN = new Color(220, 220, 240);

    static void weight(Graphics g, int x, int y, int gridSize, Weight w) {
        int intensity = (int)((w.value + 1.0f) / 2.0f * 250.0f);
        if (intensity < 0) {
            intensity = 0;
        }
        if (intensity > 250) {
            intensity = 250;
        }
        g.setColor(new Color(intensity, intensity, intensity));
        g.fillRect(x, y, gridSize, gridSize);
    }

    public static void saveFrame(Network in, int pass) {
    }

    public static void visualize(Graphics g, Network in, int pass) {
        int m3;
        int m32;
        int m1;
        int m33;
        int m;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 1000, 600);
        g.translate(30, 30);
        int weightIndex = 0;
        for (m = 0; m < 6; ++m) {
            for (int wY = 0; wY < 5; ++wY) {
                for (int wX = 0; wX < 5; ++wX) {
                    Visualizer.weight(g, (m * 12 + wX) * 10, wY * 10, 10, in.layers.get((int)0).weights.get(weightIndex++));
                }
            }
            Visualizer.weight(g, (m * 12 + 5) * 10, 0, 10, in.layers.get((int)0).weights.get(weightIndex++));
        }
        g.setColor(CONN);
        for (m = 0; m < 6; ++m) {
            g.drawLine(m * 12 * 10, 52, m * 12 * 10, 78);
        }
        weightIndex = 0;
        for (m = 0; m < 6; ++m) {
            Visualizer.weight(g, m * 12 * 10, 80, 10, in.layers.get((int)1).weights.get(weightIndex++));
        }
        boolean X = true;
        boolean O = false;
        boolean[][] table = new boolean[][]{{X, O, O, O, X, X, X, O, O, X, X, X, X, O, X, X}, {X, X, O, O, O, X, X, X, O, O, X, X, X, X, O, X}, {X, X, X, O, O, O, X, X, X, O, O, X, O, X, X, X}, {O, X, X, X, O, O, X, X, X, X, O, O, X, O, X, X}, {O, O, X, X, X, O, O, X, X, X, X, O, X, X, O, X}, {O, O, O, X, X, X, O, O, X, X, X, X, O, X, X, X}};
        int[] m3Sizes = new int[16];
        for (int m12 = 0; m12 < 6; ++m12) {
            for (m33 = 0; m33 < 16; ++m33) {
                if (!table[m12][m33]) continue;
                int n = m33;
                m3Sizes[n] = m3Sizes[n] + 1;
            }
        }
        int[] m3Offsets = new int[16];
        for (m33 = 1; m33 < 16; ++m33) {
            m3Offsets[m33] = m3Sizes[m33 - 1] + m3Offsets[m33 - 1];
        }
        g.setColor(CONN);
        int[] m3Indices = new int[16];
        for (m1 = 0; m1 < 6; ++m1) {
            for (m32 = 0; m32 < 16; ++m32) {
                if (!table[m1][m32]) continue;
                g.drawLine(m1 * 12 * 10, 92, (m3Indices[m32] * 6 + m3Offsets[m32] * 6 + m32 * 8) * 2, 248);
                int n = m32;
                m3Indices[n] = m3Indices[n] + 1;
            }
        }
        weightIndex = 0;
        m3Indices = new int[16];
        for (m1 = 0; m1 < 6; ++m1) {
            for (m32 = 0; m32 < 16; ++m32) {
                if (!table[m1][m32]) continue;
                for (int wY = 0; wY < 5; ++wY) {
                    for (int wX = 0; wX < 5; ++wX) {
                        Visualizer.weight(g, (m3Indices[m32] * 6 + m3Offsets[m32] * 6 + m32 * 8 + wX) * 2, 250 + wY * 2, 2, in.layers.get((int)2).weights.get(weightIndex++));
                    }
                }
                int n = m32;
                m3Indices[n] = m3Indices[n] + 1;
            }
        }
        for (m3 = 0; m3 < 16; ++m3) {
            Visualizer.weight(g, (m3Indices[m3] * 6 + m3Offsets[m3] * 6 + m3 * 8) * 2, 250, 2, in.layers.get((int)2).weights.get(weightIndex++));
        }
        g.setColor(CONN);
        for (m3 = 0; m3 < 16; ++m3) {
            g.drawRect(m3Offsets[m3] * 12 + m3 * 16 - 2, 248, m3Sizes[m3] * 12 + 5, 13);
            g.drawLine(m3Offsets[m3] * 12 + m3 * 16, 261, m3Offsets[m3] * 12 + m3 * 16, 278);
        }
        weightIndex = 0;
        for (m3 = 0; m3 < 16; ++m3) {
            Visualizer.weight(g, (m3Offsets[m3] * 6 + m3 * 8) * 2, 280, 5, in.layers.get((int)3).weights.get(weightIndex++));
        }
        weightIndex = 0;
        for (m3 = 0; m3 < 16; ++m3) {
            for (int out = 0; out < 128; ++out) {
                Visualizer.weight(g, (m3Offsets[m3] * 6 + m3 * 8) * 2 + out % 8 * 4, 320 + out / 8 * 4, 4, in.layers.get((int)4).weights.get(weightIndex++));
            }
        }
        for (int out = 0; out < 128; ++out) {
            Visualizer.weight(g, out % 8 * 4, 420 + out / 8 * 4, 4, in.layers.get((int)4).weights.get(weightIndex++));
        }
        g.setColor(CONN);
        g.drawLine(0, 286, 922, 315);
        g.drawLine(922, 286, 0, 315);
        g.drawRect(-3, 317, 925, 169);
        g.setColor(Color.BLACK);
        g.drawString("Pass " + pass, 0, -12);
    }

    static class VisFrame
    extends JFrame {
        Canvas c = new Canvas();

        public VisFrame() {
            super("Neural Network Training");
            this.getContentPane().add(this.c);
            this.setSize(1000, 600);
            this.setVisible(true);
            this.c.createBufferStrategy(2);
        }

        public void update(Network in, int pass) {
            Visualizer.visualize(this.c.getBufferStrategy().getDrawGraphics(), in, pass);
            this.c.getBufferStrategy().show();
        }
    }
}

