/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.nnidentifier.Example;
import com.zarkonnen.longan.nnidentifier.network.Connection;
import com.zarkonnen.longan.nnidentifier.network.Layer;
import com.zarkonnen.longan.nnidentifier.network.Network;
import com.zarkonnen.longan.nnidentifier.network.Node;
import com.zarkonnen.longan.nnidentifier.network.Util;
import com.zarkonnen.longan.nnidentifier.network.Weight;
import java.util.ArrayList;
import java.util.Random;

public class DiscriminatorNet {
    Network nw;
    Random r;

    public DiscriminatorNet(long seed) {
        int x;
        int y;
        int m3;
        int y2;
        int m;
        this.r = new Random(seed);
        Layer input = new Layer("Input");
        for (int y3 = 0; y3 < 28; ++y3) {
            for (int x2 = 0; x2 < 28; ++x2) {
                input.nodes.add(new Node("input " + y3 + "/" + x2));
            }
        }
        Node biasN = new Node("input bias");
        biasN.activation = 1.0f;
        Layer h1 = new Layer("H1 (conv)");
        for (int m2 = 0; m2 < 6; ++m2) {
            for (int y4 = 0; y4 < 24; ++y4) {
                for (int x3 = 0; x3 < 24; ++x3) {
                    h1.nodes.add(new Node("H1." + m2 + " " + y4 + "/" + x3));
                }
            }
        }
        Layer h2 = new Layer("H2 (subsampling)");
        for (int m4 = 0; m4 < 6; ++m4) {
            for (int y5 = 0; y5 < 12; ++y5) {
                for (int x4 = 0; x4 < 12; ++x4) {
                    h2.nodes.add(new Node("H2." + m4 + " " + y5 + "/" + x4));
                }
            }
        }
        Layer h3 = new Layer("H3 (conv)");
        for (int m5 = 0; m5 < 16; ++m5) {
            for (int y6 = 0; y6 < 8; ++y6) {
                for (int x5 = 0; x5 < 8; ++x5) {
                    h3.nodes.add(new Node("H3." + m5 + " " + y6 + "/" + x5));
                }
            }
        }
        Layer h4 = new Layer("H4 (subsampling)");
        for (int m6 = 0; m6 < 16; ++m6) {
            for (int y7 = 0; y7 < 4; ++y7) {
                for (int x6 = 0; x6 < 4; ++x6) {
                    h4.nodes.add(new Node("H4." + m6 + " " + y7 + "/" + x6));
                }
            }
        }
        Layer output = new Layer("Output");
        output.nodes.add(new Node("Output"));
        for (m = 0; m < 6; ++m) {
            for (int wY = 0; wY < 5; ++wY) {
                for (int wX = 0; wX < 5; ++wX) {
                    Weight w = new Weight(Util.rnd(-0.07692308f, 0.07692308f, this.r));
                    input.weights.add(w);
                    for (int y8 = 0; y8 < 24; ++y8) {
                        for (int x7 = 0; x7 < 24; ++x7) {
                            new Connection(input.nodes.get((y8 + wY) * 28 + (x7 + wX)), h1.nodes.get(m * 24 * 24 + y8 * 24 + x7), w);
                        }
                    }
                }
            }
            Weight w = new Weight(Util.rnd(-0.07692308f, 0.07692308f, this.r));
            input.weights.add(w);
            for (y2 = 0; y2 < 24; ++y2) {
                for (int x8 = 0; x8 < 24; ++x8) {
                    new Connection(biasN, h1.nodes.get(m * 24 * 24 + y2 * 24 + x8), w);
                }
            }
        }
        for (m = 0; m < 6; ++m) {
            Weight w = new Weight(0.25f);
            h1.weights.add(w);
            for (y2 = 0; y2 < 12; ++y2) {
                for (int x9 = 0; x9 < 12; ++x9) {
                    for (int dy = 0; dy < 2; ++dy) {
                        for (int dx = 0; dx < 2; ++dx) {
                            new Connection(h1.nodes.get(m * 24 * 24 + (y2 * 2 + dy) * 24 + (x9 * 2 + dx)), h2.nodes.get(m * 12 * 12 + y2 * 12 + x9), w);
                        }
                    }
                }
            }
        }
        boolean X = true;
        boolean O = false;
        boolean[][] table = new boolean[][]{{X, O, O, O, X, X, X, O, O, X, X, X, X, O, X, X}, {X, X, O, O, O, X, X, X, O, O, X, X, X, X, O, X}, {X, X, X, O, O, O, X, X, X, O, O, X, O, X, X, X}, {O, X, X, X, O, O, X, X, X, X, O, O, X, O, X, X}, {O, O, X, X, X, O, O, X, X, X, X, O, X, X, O, X}, {O, O, O, X, X, X, O, O, X, X, X, X, O, X, X, X}};
        for (int m1 = 0; m1 < 6; ++m1) {
            for (int m32 = 0; m32 < 16; ++m32) {
                if (!table[m1][m32]) continue;
                for (int wY = 0; wY < 5; ++wY) {
                    for (int wX = 0; wX < 5; ++wX) {
                        Weight w = new Weight(Util.rnd(-0.02631579f, 0.02631579f, this.r));
                        h2.weights.add(w);
                        for (int y9 = 0; y9 < 8; ++y9) {
                            for (int x10 = 0; x10 < 8; ++x10) {
                                new Connection(h2.nodes.get(m1 * 12 * 12 + (y9 + wY) * 12 + (x10 + wX)), h3.nodes.get(m32 * 8 * 8 + y9 * 8 + x10), w);
                            }
                        }
                    }
                }
            }
        }
        for (m3 = 0; m3 < 16; ++m3) {
            Weight w = new Weight(Util.rnd(-0.02631579f, 0.02631579f, this.r));
            h2.weights.add(w);
            for (y = 0; y < 8; ++y) {
                for (x = 0; x < 8; ++x) {
                    new Connection(biasN, h3.nodes.get(m3 * 8 * 8 + y * 8 + x), w);
                }
            }
        }
        for (m3 = 0; m3 < 16; ++m3) {
            Weight w = new Weight(0.25f);
            h3.weights.add(w);
            for (y = 0; y < 4; ++y) {
                for (x = 0; x < 4; ++x) {
                    for (int dy = 0; dy < 2; ++dy) {
                        for (int dx = 0; dx < 2; ++dx) {
                            new Connection(h3.nodes.get(m3 * 8 * 8 + (y * 2 + dy) * 8 + (x * 2 + dx)), h4.nodes.get(m3 * 4 * 4 + y * 4 + x), w);
                        }
                    }
                }
            }
        }
        for (Node h4N : h4.nodes) {
            for (Node oN : output.nodes) {
                Weight w = new Weight(Util.rnd(-0.010362694f, 0.010362694f, this.r));
                h4.weights.add(w);
                new Connection(h4N, oN, w);
            }
        }
        for (Node oN : output.nodes) {
            Weight w = new Weight(Util.rnd(-0.010362694f, 0.010362694f, this.r));
            h4.weights.add(w);
            new Connection(biasN, oN, w);
        }
        ArrayList<Layer> layers = new ArrayList<Layer>();
        layers.add(input);
        layers.add(h1);
        layers.add(h2);
        layers.add(h3);
        layers.add(h4);
        layers.add(output);
        this.nw = new Network(layers);
    }

    public void train(Example ex, float n, float m) {
        this.nw.train(ex.input, ex.target, n, m);
    }

    public float[] run(float[] input) {
        return this.nw.run(input);
    }
}

