/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.data;

import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Word;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Line {
    public ArrayList<Word> words = new ArrayList();
    public Rectangle boundingRect = null;
    public double avgLetterWidth = 0.0;
    public double avgLetterHeight = 0.0;

    public void add(Word w) {
        this.words.add(w);
        if (this.boundingRect == null) {
            this.boundingRect = new Rectangle(w.boundingRect);
        } else {
            this.boundingRect.add(w.boundingRect);
        }
        this.avgLetterWidth = this.avgLetterWidth();
        this.avgLetterHeight = this.avgLetterHeight();
    }

    public void regenBoundingRect() {
        this.boundingRect = null;
        for (Word w : this.words) {
            if (this.boundingRect == null) {
                this.boundingRect = new Rectangle(w.boundingRect);
                continue;
            }
            this.boundingRect.add(w.boundingRect);
        }
        this.avgLetterWidth = this.avgLetterWidth();
        this.avgLetterHeight = this.avgLetterHeight();
    }

    public int xDist(Rectangle r2) {
        if (this.boundingRect.x + this.boundingRect.width < r2.x) {
            return r2.x - this.boundingRect.x - this.boundingRect.width;
        }
        if (r2.x + r2.width < this.boundingRect.x) {
            return this.boundingRect.x - r2.x - r2.width;
        }
        return 0;
    }

    public int yDist(Rectangle r2) {
        if (this.boundingRect.y + this.boundingRect.height < r2.y) {
            return r2.y - this.boundingRect.y - this.boundingRect.height;
        }
        if (r2.y + r2.height < this.boundingRect.y) {
            return this.boundingRect.y - r2.y - r2.height;
        }
        return 0;
    }

    private double avgLetterHeight() {
        double h = 0.0;
        int n = 0;
        for (Word w : this.words) {
            for (Letter l : w.letters) {
                h += (double)l.height;
            }
            n += w.letters.size();
        }
        return h / (double)n;
    }

    private double avgLetterWidth() {
        double w = 0.0;
        int n = 0;
        for (Word word : this.words) {
            for (Letter l : word.letters) {
                w += (double)l.width;
            }
            n += word.letters.size();
        }
        return w / (double)n;
    }
}

