/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.better;

import com.zarkonnen.longan.Histogram;
import com.zarkonnen.longan.better.IntensityHistogramPreProcessor;
import com.zarkonnen.longan.stage.PreProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class RotationFixingPreProcessor
implements PreProcessor {
    static final int TILT_RANGE = 40;
    static final double TILT_DELTA = 0.0017453292519943296;
    static final double MIN_ADJUST = 0.006981317007977318;
    static final int IMAGE_H = 400;
    static final int MAX_DIM = 280;

    @Override
    public BufferedImage process(BufferedImage img, HashMap<String, String> metadata) {
        if (!metadata.containsKey("standardWhite") || !metadata.containsKey("blackWhiteBoundary")) {
            new IntensityHistogramPreProcessor().process(img, metadata);
        }
        int standardWhite = Integer.parseInt(metadata.get("standardWhite"));
        int blackWhiteBoundary = Integer.parseInt(metadata.get("blackWhiteBoundary"));
        double rotation = this.determineRotation(img, 0.0, blackWhiteBoundary);
        if (Math.abs(rotation) > 0.006981317007977318) {
            BufferedImage img2 = new BufferedImage((int)((double)img.getWidth() * (1.0 + Math.sin(Math.abs(rotation)))), (int)((double)img.getHeight() * (1.0 + Math.sin(Math.abs(rotation)))), img.getType());
            Graphics2D g2 = img2.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setColor(new Color(standardWhite, standardWhite, standardWhite));
            g2.fillRect(0, 0, img2.getWidth(), img2.getHeight());
            g2.translate(img2.getWidth() / 2, img2.getHeight() / 2);
            g2.rotate(rotation);
            g2.translate(-img.getWidth() / 2, -img.getHeight() / 2);
            g2.drawImage((Image)img, 0, 0, null);
            img = img2;
        }
        return img;
    }

    double determineRotation(BufferedImage img, double initialRotation, int blackWhiteBoundary) {
        int w = 0;
        int h = 0;
        if (img.getWidth() > img.getHeight()) {
            w = 280;
            h = 280 * img.getHeight() / img.getWidth();
        } else {
            w = 280 * img.getWidth() / img.getHeight();
            h = 280;
        }
        BufferedImage scaled = new BufferedImage(w, h, 1);
        Graphics2D sg = scaled.createGraphics();
        sg.drawImage(img, 0, 0, w, h, null);
        BufferedImage out1 = new BufferedImage(400, 400, 1);
        double bestRotation = initialRotation;
        double bestStdDev = 0.0;
        for (int t = 0; t < 80; ++t) {
            double tilt = (double)(t - 40) * 0.0017453292519943296;
            Graphics2D g1 = out1.createGraphics();
            g1.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g1.setColor(Color.WHITE);
            g1.fillRect(0, 0, 400, 400);
            g1.translate(200, 200);
            g1.rotate(tilt + initialRotation);
            g1.translate(-w / 2, -h / 2);
            g1.drawImage((Image)scaled, 0, 0, null);
            Histogram ch = new Histogram(200);
            for (int y = 0; y < 300; ++y) {
                int contactsHorizontal = 0;
                for (int x = 100; x < 300; ++x) {
                    Color c = new Color(out1.getRGB(x, y));
                    int intensity = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
                    if (intensity >= blackWhiteBoundary) continue;
                    ++contactsHorizontal;
                }
                ch.add(contactsHorizontal);
            }
            double stdDev = ch.stdDev();
            if (!(stdDev > bestStdDev)) continue;
            bestRotation = initialRotation + tilt;
            bestStdDev = stdDev;
        }
        return bestRotation;
    }
}

