/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.better;

import com.zarkonnen.longan.Histogram;
import com.zarkonnen.longan.stage.PreProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class IntensityHistogramPreProcessor
implements PreProcessor {
    public static Histogram generate(BufferedImage img) {
        Histogram hg = new Histogram(256);
        BufferedImage img2 = new BufferedImage(100, 100, 1);
        Graphics2D g = img2.createGraphics();
        g.drawImage(img, 0, 0, 100, 100, null);
        int h = img2.getHeight();
        int w = img2.getWidth();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color c = new Color(img2.getRGB(x, y));
                int intensity = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
                hg.add(intensity);
            }
        }
        hg.convolve(new double[]{0.02040816326530612, 0.04081632653061224, 0.061224489795918366, 0.08163265306122448, 0.10204081632653061, 0.12244897959183673, 0.14285714285714285, 0.12244897959183673, 0.10204081632653061, 0.08163265306122448, 0.061224489795918366, 0.04081632653061224, 0.02040816326530612});
        hg.convolve(new double[]{0.02040816326530612, 0.04081632653061224, 0.061224489795918366, 0.08163265306122448, 0.10204081632653061, 0.12244897959183673, 0.14285714285714285, 0.12244897959183673, 0.10204081632653061, 0.08163265306122448, 0.061224489795918366, 0.04081632653061224, 0.02040816326530612});
        hg.convolve(new double[]{3000.0 / (double)img2.getWidth() / (double)img2.getHeight()});
        return hg;
    }

    public static int getBlackWhiteBoundary(Histogram hg) {
        return hg.blackWhiteBoundary();
    }

    public static int getStandardWhite(Histogram hg) {
        return hg.postIndexMean(IntensityHistogramPreProcessor.getBlackWhiteBoundary(hg));
    }

    @Override
    public BufferedImage process(BufferedImage img, HashMap<String, String> metadata) {
        Histogram hg = IntensityHistogramPreProcessor.generate(img);
        int bwb = IntensityHistogramPreProcessor.getBlackWhiteBoundary(hg);
        if (!metadata.containsKey("blackWhiteBoundary")) {
            metadata.put("blackWhiteBoundary", "" + bwb);
        }
        if (!metadata.containsKey("standardWhite")) {
            metadata.put("standardWhite", "" + Math.min(255, hg.postIndexMean(bwb)));
        }
        return img;
    }
}

