/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.better;

import com.zarkonnen.longan.Histogram;
import com.zarkonnen.longan.better.WordXComparator;
import com.zarkonnen.longan.data.Column;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Line;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.data.Word;
import com.zarkonnen.longan.stage.Chunker;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class BetterChunker2
implements Chunker {
    static final int MAX_SIZE_OUTLIER = 10;
    static final double MAX_PIECE_H_DEVIATION = 1.0;
    static final double MAX_PIECE_W_DEVIATION = 1.5;
    static final double MAX_WHOLE_X_DIST = 1.6;
    static final double MAX_WHOLE_Y_DIST = 0.1;

    @Override
    public Result chunk(ArrayList<Letter> letters, BufferedImage img, HashMap<String, String> metadata) {
        Histogram sizeHistogram = new Histogram(100);
        for (Rectangle rectangle : letters) {
            sizeHistogram.add((int)Math.sqrt(rectangle.width * rectangle.height));
        }
        sizeHistogram.convolve(new double[]{0.02040816326530612, 0.04081632653061224, 0.061224489795918366, 0.08163265306122448, 0.10204081632653061, 0.12244897959183673, 0.14285714285714285, 0.12244897959183673, 0.10204081632653061, 0.08163265306122448, 0.061224489795918366, 0.04081632653061224, 0.02040816326530612});
        int avgSize = sizeHistogram.secondPeakOrFirstIfUnavailable();
        ArrayList<Letter> arrayList = new ArrayList<Letter>();
        ArrayList<Letter> pieces = new ArrayList<Letter>();
        for (Letter letter : letters) {
            double d = Math.sqrt(letter.width * letter.height);
            if (!(d <= (double)(avgSize * 10)) || letter.width > avgSize * 10 || letter.height > avgSize * 10) continue;
            if (d < (double)avgSize * 0.5) {
                pieces.add(letter);
                letter.fragment = true;
                continue;
            }
            arrayList.add(letter);
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(letters);
            pieces.clear();
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        block2: for (Letter letter : arrayList) {
            for (Line line : lines) {
                if (!((double)line.xDist(letter) < 1.6 * Math.max((double)avgSize, line.avgLetterWidth)) || !((double)line.yDist(letter) < 0.1 * Math.max((double)avgSize, line.avgLetterHeight))) continue;
                line.add(new Word(letter));
                continue block2;
            }
            Object l = new Line();
            ((Line)l).add(new Word(letter));
            lines.add(l);
        }
        block4: while (true) {
            block5: for (Line line : lines) {
                for (Line line2 : lines) {
                    if (line == line2 || !((double)line.xDist(line2.boundingRect) < 1.6 * Math.max((double)avgSize, line.avgLetterWidth)) || !((double)line.yDist(line2.boundingRect) < 0.1 * Math.max((double)avgSize, line.avgLetterHeight))) continue;
                    for (Word word : line2.words) {
                        line.add(word);
                    }
                    lines.remove(line2);
                    continue block4;
                    continue block5;
                }
            }
            break;
        }
        for (Line line : lines) {
            Collections.sort(line.words, new WordXComparator());
        }
        Histogram histogram = new Histogram(500);
        for (Object l : lines) {
            for (int i = 0; i < ((Line)l).words.size() - 1; ++i) {
                Rectangle rectangle = ((Line)l).words.get((int)i).letters.get(0);
                Rectangle r1 = ((Line)l).words.get((int)(i + 1)).letters.get(0);
                histogram.add(r1.x - (rectangle.x + rectangle.width));
            }
        }
        if (histogram.count() > 100 && histogram.average() > 3.0) {
            histogram.convolve(new double[]{0.05, 0.15, 0.2, 0.15, 0.05});
            histogram.convolve(new double[]{100.0 / (double)histogram.count()});
        }
        int n = histogram.firstValleyEnd() - 3;
        metadata.put("letterToWordSpacingBoundary", "" + n);
        Result result = new Result();
        result.img = img;
        result.metadata = metadata;
        for (Line line : lines) {
            this.putLineIntoColumns(result.columns, line, n);
        }
        for (Letter letter : pieces) {
            double bestVDist = 100000.0;
            Line bestL = null;
            for (Line line : lines) {
                double hDist;
                double vDist = Math.abs(letter.getCenterY() - line.boundingRect.getCenterY());
                Rectangle b = line.boundingRect;
                double d = letter.getCenterX() < (double)b.x ? (double)b.x - letter.getCenterX() : (hDist = letter.getCenterX() > (double)(b.x + b.width) ? letter.getCenterX() - (double)b.x - (double)b.width : 0.0);
                if (vDist > line.avgLetterHeight * 1.0 || hDist > line.avgLetterWidth * 1.5 || bestL != null && !(vDist < bestVDist)) continue;
                bestVDist = vDist;
                bestL = line;
            }
            if (bestL == null) continue;
            bestL.add(new Word(letter));
        }
        for (Line line : lines) {
            Collections.sort(line.words, new WordXComparator());
        }
        for (Line line : lines) {
            for (int i = 0; i < line.words.size() - 1; ++i) {
                int overlapPx;
                Letter r0 = line.words.get((int)i).letters.get(0);
                Letter r1 = line.words.get((int)(i + 1)).letters.get(0);
                if (r0.x + r0.width < r1.x + r1.width && (double)(overlapPx = r0.x + r0.width - r1.x) < (double)Math.min(r0.width, r1.width) * 0.2) continue;
                Letter newR = r0.add(r1);
                line.words.add(i, new Word(newR));
                line.words.remove(i + 1);
                line.words.remove(i + 1);
                --i;
            }
        }
        for (Line line : lines) {
            for (Word w : line.words) {
                Letter letter = w.letters.get(0);
                letter.relativeLineOffset = (letter.getCenterY() - line.boundingRect.getCenterY()) / (double)avgSize;
                letter.relativeSize = Math.sqrt(letter.width * letter.height) / (double)avgSize;
            }
        }
        for (Column column : result.columns) {
            for (Line line : column.lines) {
                ArrayList<Word> newWords = new ArrayList<Word>();
                Word currentWord = new Word(line.words.get((int)0).letters.get(0));
                for (int i = 0; i < line.words.size() - 1; ++i) {
                    Letter l0 = line.words.get((int)i).letters.get(0);
                    Letter l1 = line.words.get((int)(i + 1)).letters.get(0);
                    int dist = l1.x - (l0.x + l0.width);
                    if (dist > n) {
                        newWords.add(currentWord);
                        currentWord = new Word(l1);
                        continue;
                    }
                    currentWord.add(l1);
                }
                newWords.add(currentWord);
                line.words.clear();
                line.words.addAll(newWords);
            }
        }
        return result;
    }

    void putLineIntoColumns(ArrayList<Column> cols, Line l, int letterToWordSpacingBoundary) {
        Column closestCol = null;
        int closestColDist = Integer.MAX_VALUE;
        Column insertCol = null;
        for (Column col : cols) {
            int xStart = col.averageXStart();
            int d = xStart - l.words.get((int)0).letters.get((int)0).x;
            if (Math.abs(d) < closestColDist) {
                closestCol = col;
                closestColDist = Math.abs(d);
            }
            if (d <= 0) continue;
            insertCol = col;
        }
        if (closestColDist < letterToWordSpacingBoundary * 4) {
            closestCol.lines.add(l);
        } else {
            Column newCol = new Column();
            newCol.lines.add(l);
            if (insertCol == null) {
                cols.add(newCol);
            } else {
                cols.add(cols.indexOf(insertCol), newCol);
            }
        }
    }
}

