/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.better;

import com.zarkonnen.longan.Longan;
import com.zarkonnen.longan.data.Column;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Line;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.data.Word;
import com.zarkonnen.longan.nnidentifier.Identifier;
import com.zarkonnen.longan.stage.PostProcessor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AggressiveLetterSplittingPostProcessor
implements PostProcessor {
    static final double LOW_SCORE_BOUNDARY = 0.75;
    static final double RECURSE_COST = 0.03;
    static final double SAW_WIDTH_TOLERANCE = 1.2;
    static final int MAX_RECURSION = 3;
    static final double MIN_IMPLAUSIBILITY_SCORE_DELTA = 0.02;
    static final double MIN_IMPROVEMENT = 0.14;
    static final double MAX_SZ_DEV = 1.6;
    int q = 0;

    ArrayList<Letter> split(Letter srcLetter, Letter topLetter, Word word, Line line, Column c, Result result, Longan longan, int recursion) {
        if (recursion > 3) {
            return null;
        }
        ArrayList<Letter> output = new ArrayList<Letter>();
        ArrayList<Letter> lrs = AggressiveLetterSplittingPostProcessor.sawApart(srcLetter, result.img);
        if (lrs == null) {
            return null;
        }
        for (Letter letter : lrs) {
            if (letter.width == 0 || letter.height == 0) continue;
            longan.letterIdentifier.reIdentify(letter, topLetter, word, line, c, result);
            ArrayList<Letter> sub = this.split(letter, topLetter, word, line, c, result, longan, recursion + 1);
            if (sub == null) {
                output.add(letter);
                continue;
            }
            output.addAll(sub);
        }
        return output.isEmpty() || this.worstScoreIn(output, c) - 0.03 < this.bestPlausibleScore(srcLetter, c) ? null : output;
    }

    double bestPlausibleScore(Letter l, Column c) {
        double score = 0.0;
        HashMap expectedSizes = c.metadata.has(Identifier.IDENTIFIER_USED) ? c.metadata.get(Identifier.IDENTIFIER_USED).expectedRelativeSizes : new HashMap();
        for (Map.Entry<ArrayList<String>, Double> e : l.possibleLetters.entrySet()) {
            boolean plausible = false;
            for (String pLetter : e.getKey()) {
                if (!expectedSizes.containsKey(pLetter) || !(l.relativeSize < (Double)expectedSizes.get(pLetter) * 1.6)) continue;
                plausible = true;
                break;
            }
            if (!plausible) continue;
            score = Math.max(score, e.getValue());
        }
        return score;
    }

    double worstScoreIn(ArrayList<Letter> list, Column c) {
        double ws = 1.0;
        for (Letter l : list) {
            ws = Math.min(ws, this.bestPlausibleScore(l, c));
        }
        return ws;
    }

    double avgPlausibleScoreIn(ArrayList<Letter> list, Column c) {
        double acc = 0.0;
        for (Letter l : list) {
            acc += this.bestPlausibleScore(l, c);
        }
        return acc / (double)list.size();
    }

    @Override
    public void process(Result result, Longan longan) {
        for (Column c : result.columns) {
            for (Line line : c.lines) {
                for (Word word : line.words) {
                    for (int i = 0; i < word.letters.size(); ++i) {
                        ArrayList<Letter> newLs;
                        boolean implausibleLetter;
                        Letter l = word.letters.get(i);
                        double score = l.bestScore();
                        double plausibleScore = this.bestPlausibleScore(l, c);
                        boolean bl = implausibleLetter = plausibleScore + 0.02 < score;
                        if (!(plausibleScore < 0.75) || (newLs = this.split(l, l, word, line, c, result, longan, 0)) == null || !implausibleLetter && !(this.avgPlausibleScoreIn(newLs, c) > plausibleScore + 0.14)) continue;
                        word.letters.remove(i);
                        word.letters.addAll(i, newLs);
                        i += newLs.size() - 1;
                    }
                }
            }
        }
    }

    static ArrayList<Letter> sawApart(Letter l, BufferedImage img) {
        int bestSawPosition = -1;
        int lowestResistance = Integer.MAX_VALUE;
        for (int saw = l.width / 4; saw < l.width * 3 / 4 - 1; ++saw) {
            int resistance = 0;
            for (int blade = 0; blade < l.height; ++blade) {
                if (!l.mask[blade][saw]) continue;
                Color c = new Color(img.getRGB(l.x + saw, l.y + blade));
                resistance += 765 - c.getRed() - c.getGreen() - c.getBlue();
            }
            if (resistance >= lowestResistance) continue;
            lowestResistance = resistance;
            bestSawPosition = saw;
        }
        if (bestSawPosition != -1) {
            int sawLeftWiden = 0;
            for (int saw = bestSawPosition - 1; saw > 0; --saw) {
                int resistance = 0;
                for (int blade = 0; blade < l.height; ++blade) {
                    if (!l.mask[blade][saw]) continue;
                    Color c = new Color(img.getRGB(l.x + saw, l.y + blade));
                    resistance += 765 - c.getRed() - c.getGreen() - c.getBlue();
                }
                if (!((double)resistance <= (double)lowestResistance * 1.2)) break;
                ++sawLeftWiden;
            }
            int sawRightWiden = 0;
            for (int saw = bestSawPosition; saw < l.width - 2; ++saw) {
                int resistance = 0;
                for (int blade = 0; blade < l.height; ++blade) {
                    if (!l.mask[blade][saw]) continue;
                    Color c = new Color(img.getRGB(l.x + saw, l.y + blade));
                    resistance += 765 - c.getRed() - c.getGreen() - c.getBlue();
                }
                if (!((double)resistance <= (double)lowestResistance * 1.2)) break;
                ++sawRightWiden;
            }
            return l.splitAlongXAxis(bestSawPosition -= sawLeftWiden, sawLeftWiden + sawRightWiden);
        }
        return null;
    }
}

