/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan;

import com.zarkonnen.longan.Longan;
import com.zarkonnen.longan.Visualizer;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.simple.SimpleWordPlaintextConverter;
import com.zarkonnen.longan.stage.ResultConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    static final String INVOCATION = "java -Xmx512m -jar longan.jar [OPTIONS] [INPUT FILE]";
    static final ResultConverter<String> DEFAULT_FORMAT = new SimpleWordPlaintextConverter();
    static final HashMap<String, ResultConverter> FORMATS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        block34: {
            Options options = new Options();
            OptionBuilder.withDescription((String)"print help");
            Option helpO = OptionBuilder.create((String)"h");
            OptionBuilder.withDescription((String)"print version");
            Option versionO = OptionBuilder.create((String)"v");
            OptionBuilder.withDescription((String)"output file");
            OptionBuilder.withLongOpt((String)"out");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"file");
            Option outputO = OptionBuilder.create((String)"o");
            OptionBuilder.withDescription((String)"output format: one of plaintext (default) and visualize (debug output in png)");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"format");
            OptionBuilder.withLongOpt((String)"format");
            Option formatO = OptionBuilder.create();
            OptionBuilder.withDescription((String)"launches server mode: Server mode reads command line strings one per line exactly as above. If no output file is specified, returns a line containing the number of output lines before the output. If there is an error, returns a single line with the error message. Shut down server by sending \"quit\".");
            OptionBuilder.withLongOpt((String)"server");
            Option serverO = OptionBuilder.create();
            OptionBuilder.withDescription((String)"enables use of the graphics card to support the OCR system. Defaults to true.");
            OptionBuilder.withLongOpt((String)"enable-opencl");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"enabled");
            Option openCLO = OptionBuilder.create();
            options.addOption(helpO);
            options.addOption(versionO);
            options.addOption(outputO);
            options.addOption(formatO);
            options.addOption(serverO);
            options.addOption(openCLO);
            GnuParser clp = new GnuParser();
            try {
                File inFile;
                ResultConverter format;
                CommandLine line = clp.parse(options, args);
                if (line.hasOption("h")) {
                    new HelpFormatter().printHelp(INVOCATION, options);
                    System.exit(0);
                }
                if (line.hasOption("v")) {
                    System.out.println("0.9");
                    System.exit(0);
                }
                boolean enableOpenCL = true;
                if (line.hasOption("enable-opencl")) {
                    boolean bl = enableOpenCL = line.getOptionValue("enable-opencl").toLowerCase().equals("true") || line.getOptionValue("enable-opencl").equals("1");
                }
                if (line.hasOption("server")) {
                    Longan longan = Longan.getDefaultImplementation(enableOpenCL);
                    BufferedReader inputR = new BufferedReader(new InputStreamReader(System.in));
                    while (true) {
                        String input;
                        if ((input = inputR.readLine()).trim().equals("quit")) {
                            return;
                        }
                        String[] args2 = Main.splitInput(input);
                        Options o2 = new Options();
                        o2.addOption(outputO);
                        o2.addOption(formatO);
                        try {
                            ResultConverter format2;
                            line = clp.parse(o2, args2);
                            File outFile = null;
                            if (line.hasOption("o")) {
                                outFile = new File(line.getOptionValue("o"));
                            }
                            if ((format2 = FORMATS.get(line.getOptionValue("format", "plaintext"))) != DEFAULT_FORMAT && outFile == null) {
                                System.out.println("You must specify an output file for non-plaintext output.");
                                continue;
                            }
                            if (line.getArgList().isEmpty()) {
                                System.out.println("Please specify an input image.");
                                continue;
                            }
                            if (line.getArgList().size() > 1) {
                                System.err.println("Please specify one input image at a time");
                                continue;
                            }
                            File inFile2 = new File((String)line.getArgList().get(0));
                            if (!inFile2.exists()) {
                                System.out.println("The input image does not exist.");
                                continue;
                            }
                            try {
                                Result result = longan.process(ImageIO.read(inFile2));
                                if (outFile == null) {
                                    String txt = DEFAULT_FORMAT.convert(result);
                                    System.out.println(Main.numNewlines(txt) + 1);
                                    System.out.print(txt);
                                    continue;
                                }
                                if (outFile.getAbsoluteFile().getParentFile() != null && !outFile.getAbsoluteFile().getParentFile().exists()) {
                                    outFile.getParentFile().mkdirs();
                                }
                                try (FileOutputStream fos = new FileOutputStream(outFile);){
                                    format2.write(result, fos);
                                }
                            }
                            catch (Exception e) {
                                System.out.println("Processing error: " + Main.exception(e));
                            }
                        }
                        catch (ParseException e) {
                            System.out.println("Input not recognized: " + Main.exception((Exception)((Object)e)));
                        }
                    }
                }
                File outFile = null;
                if (line.hasOption("o")) {
                    outFile = new File(line.getOptionValue("o"));
                }
                if ((format = FORMATS.get(line.getOptionValue("format", "plaintext"))) != DEFAULT_FORMAT && outFile == null) {
                    System.err.println("You must specify an output file for non-plaintext output.");
                    System.exit(1);
                }
                if (line.getArgList().isEmpty()) {
                    System.err.println("Please specify an input image.");
                    new HelpFormatter().printHelp(INVOCATION, options);
                    System.exit(1);
                }
                if (line.getArgList().size() > 1) {
                    System.err.println("Please specify one input image only. To process multiple images, use server mode.");
                    System.exit(1);
                }
                if (!(inFile = new File((String)line.getArgList().get(0))).exists()) {
                    System.err.println("The input image does not exist.");
                    System.exit(1);
                }
                try {
                    Result result = Longan.getDefaultImplementation(enableOpenCL).process(ImageIO.read(inFile));
                    if (outFile == null) {
                        String txt = DEFAULT_FORMAT.convert(result);
                        System.out.print(txt);
                        break block34;
                    }
                    if (outFile.getAbsoluteFile().getParentFile() != null && !outFile.getAbsoluteFile().getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    try (FileOutputStream fos = new FileOutputStream(outFile);){
                        format.write(format.convert(result), fos);
                    }
                }
                catch (Exception e) {
                    System.err.println("Processing error: " + Main.exception(e));
                    System.exit(1);
                }
            }
            catch (ParseException e) {
                System.err.println("Parsing command line input failed: " + Main.exception((Exception)((Object)e)));
                System.exit(1);
            }
        }
    }

    static int numNewlines(String str) {
        int n = 0;
        for (int i = 0; i < str.length(); ++i) {
            n += str.charAt(i) == '\n' ? 1 : 0;
        }
        return n;
    }

    static String[] splitInput(String input) {
        StringBuilder b = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean escaped = false;
        block6: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escaped) {
                b.append(c);
                escaped = false;
                continue;
            }
            if (singleQuoted && c != '\'' || doubleQuoted && c == '\'') {
                b.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block6;
                }
                case '\"': {
                    doubleQuoted = !doubleQuoted;
                    continue block6;
                }
                case '\'': {
                    singleQuoted = !singleQuoted;
                    continue block6;
                }
                case ' ': {
                    if (singleQuoted || doubleQuoted) {
                        b.append(c);
                        continue block6;
                    }
                    if (b.length() <= 0) continue block6;
                    args.add(b.toString());
                    b = new StringBuilder();
                    continue block6;
                }
                default: {
                    b.append(c);
                }
            }
        }
        if (doubleQuoted) {
            throw new RuntimeException("Mismatched quotes in input.");
        }
        if (b.length() > 0) {
            args.add(b.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    static String exception(Exception e) {
        e.printStackTrace();
        return e.getMessage() == null ? e.getClass().getName() : e.getMessage().replace("\n", " ").replace("\r", " ");
    }

    static {
        FORMATS.put("plaintext", DEFAULT_FORMAT);
        FORMATS.put("visualize", new Visualizer());
    }
}

