/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan;

import com.zarkonnen.longan.better.BetterChunker2;
import com.zarkonnen.longan.better.BetterLetterFinder;
import com.zarkonnen.longan.better.IntensityHistogramPreProcessor;
import com.zarkonnen.longan.better.LetterSplittingPostProcessor;
import com.zarkonnen.longan.better.RotationFixingPreProcessor;
import com.zarkonnen.longan.better.SpeckleEliminator;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.nnidentifier.Identifier;
import com.zarkonnen.longan.simple.SimpleWordPlaintextConverter;
import com.zarkonnen.longan.stage.Chunker;
import com.zarkonnen.longan.stage.LetterFinder;
import com.zarkonnen.longan.stage.LetterIdentifier;
import com.zarkonnen.longan.stage.PostProcessor;
import com.zarkonnen.longan.stage.PreProcessor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Longan {
    public static final String VERSION = "0.9";
    public final boolean enableOpenCL;
    public final List<PreProcessor> preProcessors;
    public final LetterFinder letterFinder;
    public final LetterIdentifier letterIdentifier;
    public final Chunker chunker;
    public final List<PostProcessor> postProcessors;

    public static Longan getDefaultImplementation() {
        return Longan.getDefaultImplementation(true);
    }

    public static Longan getDefaultImplementation(boolean enableOpenCL) {
        ArrayList<PreProcessor> preps = new ArrayList<PreProcessor>();
        preps.add(new IntensityHistogramPreProcessor());
        preps.add(new RotationFixingPreProcessor());
        ArrayList<PostProcessor> pps = new ArrayList<PostProcessor>();
        pps.add(new LetterSplittingPostProcessor());
        pps.add(new SpeckleEliminator());
        return new Longan(preps, new BetterLetterFinder(), new BetterChunker2(), new Identifier(), pps, enableOpenCL);
    }

    public static String recognize(BufferedImage img) {
        return new SimpleWordPlaintextConverter().convert(Longan.getDefaultImplementation().process(img));
    }

    public Longan(List<PreProcessor> preProcessors, LetterFinder letterFinder, Chunker chunker, LetterIdentifier letterIdentifier, List<PostProcessor> postProcessors, boolean enableOpenCL) {
        this.preProcessors = preProcessors;
        this.letterFinder = letterFinder;
        this.letterIdentifier = letterIdentifier;
        this.chunker = chunker;
        this.postProcessors = postProcessors;
        this.enableOpenCL = enableOpenCL;
    }

    public Result process(BufferedImage img) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("enableOpenCL", "" + this.enableOpenCL);
        for (PreProcessor pp : this.preProcessors) {
            img = pp.process(img, metadata);
        }
        ArrayList<Letter> Letters = this.letterFinder.find(img, metadata);
        Result result = this.chunker.chunk(Letters, img, metadata);
        this.letterIdentifier.identify(result);
        for (PostProcessor pp : this.postProcessors) {
            pp.process(result, this);
        }
        this.letterIdentifier.finish();
        return result;
    }
}

