/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Histogram {
    private int[] hg;
    private int offset = 0;

    public Histogram(int range) {
        this.hg = new int[range];
    }

    public void add(int value) {
        if (value >= 0 && value < this.hg.length) {
            int n = value;
            this.hg[n] = this.hg[n] + 1;
        }
    }

    public void set(int value, int amount) {
        if (value >= 0 && value < this.hg.length) {
            this.hg[value] = amount;
        }
    }

    public int count() {
        int c = 0;
        for (int b : this.hg) {
            c += b;
        }
        return c;
    }

    public void convolve(double[] kernel) {
        int[] newHg = new int[this.hg.length + kernel.length * 2];
        this.offset -= kernel.length / 2;
        for (int i = 0; i < newHg.length; ++i) {
            double value = 0.0;
            for (int j = 0; j < kernel.length; ++j) {
                int p = i + j - kernel.length;
                value += kernel[j] * (double)(p < 0 || p >= this.hg.length ? 0 : this.hg[p]);
            }
            newHg[i] = (int)value;
        }
        this.hg = newHg;
    }

    public int postIndexMean(int index) {
        long sum = 0L;
        long n = 0L;
        for (int i = index - this.offset; i < this.hg.length; ++i) {
            sum += (long)(i * this.hg[i]);
            n += (long)this.hg[i];
        }
        if (n == 0L) {
            return index;
        }
        int mean = (int)(sum / n);
        return mean + this.offset;
    }

    public int maxPeak() {
        int p = 0;
        for (int i = 0; i < this.hg.length; ++i) {
            if (this.hg[i] <= p) continue;
            p = this.hg[i];
        }
        return p;
    }

    public int maxPeakPos() {
        int p = 0;
        int pos = 0;
        for (int i = 0; i < this.hg.length; ++i) {
            if (this.hg[i] <= p) continue;
            p = this.hg[i];
            pos = i;
        }
        return pos + this.offset;
    }

    public int blackWhiteBoundary() {
        return this.firstValleyEnd(127);
    }

    public int altBlackWhiteBoundary() {
        int blackWhitePoint;
        int fwe = this.firstValleyEnd() - this.offset;
        int bestValue = -1;
        int lastPeak = this.hg.length - 1;
        for (int i = this.hg.length - 1; i >= 0 && this.hg[i] >= bestValue; --i) {
            lastPeak = i;
            bestValue = this.hg[i];
        }
        for (blackWhitePoint = lastPeak - 1; blackWhitePoint >= fwe && !((double)this.hg[blackWhitePoint] < (double)bestValue * 0.2); --blackWhitePoint) {
        }
        int cmpVal = this.hg[blackWhitePoint];
        while (blackWhitePoint >= fwe) {
            if (this.hg[blackWhitePoint] > cmpVal) {
                return blackWhitePoint + this.offset;
            }
            cmpVal = this.hg[blackWhitePoint];
            --blackWhitePoint;
        }
        return fwe + this.offset;
    }

    public int secondPeakOrFirstIfUnavailable() {
        int fpPtr = 0;
        int best = 0;
        for (int i = 0; i < this.hg.length && this.hg[i] >= best; ++i) {
            fpPtr = i;
            best = this.hg[i];
        }
        int vallPtr = fpPtr;
        for (int i = fpPtr; i < this.hg.length + 1; ++i) {
            if (i == this.hg.length) {
                return fpPtr + this.offset;
            }
            if (this.hg[i] > best) break;
            vallPtr = i;
            best = this.hg[i];
        }
        int spPtr = vallPtr;
        for (int i = vallPtr; i < this.hg.length + 1; ++i) {
            if (i == this.hg.length) {
                return fpPtr + this.offset;
            }
            if (this.hg[i] < best) break;
            spPtr = i;
            best = this.hg[i];
        }
        return spPtr + this.offset;
    }

    public int firstPeak() {
        int bestValue = -1;
        int firstPeak = 0;
        for (int i = 0; i < this.hg.length && this.hg[i] >= bestValue; ++i) {
            firstPeak = i;
            bestValue = this.hg[i];
        }
        return firstPeak;
    }

    public int firstValleyEnd() {
        return this.firstValleyEnd(this.offset);
    }

    public int firstValleyEnd(int atLeast) {
        atLeast -= this.offset;
        int bestValue = -1;
        int firstPeak = 0;
        for (int i = 0; i < this.hg.length && this.hg[i] >= bestValue; ++i) {
            firstPeak = i;
            bestValue = this.hg[i];
        }
        int valleyEnd = firstPeak;
        for (int i = firstPeak + 1; i < this.hg.length; ++i) {
            if (this.hg[i] > bestValue && i >= atLeast) {
                return valleyEnd + this.offset;
            }
            valleyEnd = i;
            bestValue = this.hg[i];
        }
        return valleyEnd + this.offset;
    }

    public double average() {
        long sum = 0L;
        long count = 0L;
        for (int i = 0; i < this.hg.length; ++i) {
            sum += (long)((i + this.offset) * this.hg[i]);
            count += (long)this.hg[i];
        }
        return (double)sum / (double)count;
    }

    public double stdDev() {
        double avg = this.average();
        long deltas = 0L;
        for (int i = 0; i < this.hg.length; ++i) {
            deltas = (long)((double)deltas + (double)this.hg[i] * ((double)(i + this.offset) - avg) * ((double)(i + this.offset) - avg));
        }
        return Math.sqrt(deltas);
    }

    public BufferedImage toImage() {
        int max = 0;
        for (int i = 0; i < this.hg.length; ++i) {
            if (this.hg[i] <= max) continue;
            max = this.hg[i];
        }
        int squash = 1;
        if (max > 400) {
            squash = max / 400 + 1;
        }
        BufferedImage img = new BufferedImage(this.hg.length, max / squash, 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.hg.length, max / squash);
        g.setColor(Color.BLACK);
        int bwp = this.altBlackWhiteBoundary() - this.offset;
        int fwe = this.firstValleyEnd() - this.offset;
        int fwe127 = this.blackWhiteBoundary() - this.offset;
        int p2 = this.secondPeakOrFirstIfUnavailable() - this.offset;
        for (int i = 0; i < this.hg.length; ++i) {
            if (i == bwp) {
                g.setColor(Color.RED);
                g.fillRect(i, 0, 1, max / squash);
            } else if (i == fwe) {
                g.setColor(Color.GREEN);
                g.fillRect(i, 0, 1, max / squash);
            } else if (i == fwe127) {
                g.setColor(Color.BLUE);
                g.fillRect(i, 0, 1, max / squash);
            }
            if (i == fwe && i == bwp) {
                g.setColor(Color.ORANGE);
                g.fillRect(i, 0, 1, max / squash);
            }
            if (i == fwe127 && i == fwe) {
                g.setColor(Color.CYAN);
                g.fillRect(i, 0, 1, max / squash);
            }
            if (i == fwe127 && i == bwp) {
                g.setColor(Color.MAGENTA);
                g.fillRect(i, 0, 1, max / squash);
            }
            g.setColor(Color.BLACK);
            g.fillRect(i, (max - this.hg[i]) / squash, 1, this.hg[i] / squash);
            if (i == p2) {
                g.setColor(new Color(127, 127, 127, 63));
                g.fillRect(i, 0, 1, max / squash);
            }
            if (i != -this.offset) continue;
            g.setColor(Color.RED);
            g.fillRect(i, 0, 1, 1);
        }
        return img;
    }
}

