/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.fruitbat.atrio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleATRReader {
    private final BufferedReader in;
    private boolean waitingForRecordStart = true;

    public SimpleATRReader(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in));
    }

    public void close() throws IOException {
        this.in.close();
    }

    public List<String> readRecord() throws IOException {
        String line;
        int recordEndMarker;
        if (this.waitingForRecordStart) {
            this.waitingForRecordStart = false;
            if (this.in.readLine() == null) {
                return null;
            }
        }
        do {
            if ((line = this.in.readLine()) != null) continue;
            return null;
        } while ((recordEndMarker = line.indexOf("%")) == -1);
        String[] rawFields = (line = line.substring(0, recordEndMarker)).split("[:]", -1);
        if (rawFields.length == 0) {
            return Collections.emptyList();
        }
        int firstFieldIndex = rawFields[0].length() == 0 ? 1 : 2;
        ArrayList<String> fields = new ArrayList<String>(rawFields.length);
        for (int i = firstFieldIndex; i < rawFields.length; ++i) {
            String field = rawFields[i];
            if (!field.endsWith("\t")) continue;
            int backslashUIndex = -1;
            try {
                while ((backslashUIndex = field.indexOf("\\u", backslashUIndex + 1)) != -1) {
                    if (backslashUIndex > field.length() - 7) continue;
                    String hexNum = field.substring(backslashUIndex + 2, backslashUIndex + 8);
                    String chars = new String(Character.toChars(Integer.parseInt(hexNum, 16)));
                    field = field.substring(0, backslashUIndex) + chars + field.substring(backslashUIndex + 8);
                }
            }
            catch (NumberFormatException e) {
                continue;
            }
            field = field.replace("\\r", "\r");
            field = field.replace("\\n", "\n");
            field = field.replace("\\p", "%");
            field = field.replace("\\c", ":");
            field = field.replace("\\t", "\t");
            field = field.replace("\\\\", "\\");
            fields.add(field.substring(0, field.length() - 1));
        }
        return fields;
    }
}

