/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.fruitbat.atrio;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ATRReader {
    static final int EOS = -1;
    private final InputStream in;
    private char[] buffer = new char[128];
    private int bOffset = 0;
    private boolean endOfRecord = true;
    private boolean cleanEndOfRecord = true;
    private boolean endOfStream = false;
    private Expecting expecting;

    public ATRReader(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean endOfStream() {
        return this.endOfStream;
    }

    public boolean endOfRecord() {
        return this.endOfRecord;
    }

    public boolean cleanEndOfRecord() {
        return this.cleanEndOfRecord;
    }

    void resetField() {
        this.expecting = Expecting.START_OF_FIELD;
        this.bOffset = 0;
    }

    public List<String> readRecord() throws IOException {
        ArrayList<String> fs = new ArrayList<String>();
        do {
            String f;
            fs.clear();
            while ((f = this.read()) != null) {
                fs.add(f);
            }
            if (!this.endOfStream()) continue;
            return null;
        } while (!this.cleanEndOfRecord());
        return fs;
    }

    public int readRecord(String[] into, int offset, int max) throws IOException {
        int fieldsRead;
        do {
            String f;
            fieldsRead = 0;
            while ((f = this.read()) != null) {
                if (fieldsRead >= max) continue;
                into[offset + fieldsRead++] = f;
            }
            if (!this.endOfStream()) continue;
            return -1;
        } while (!this.cleanEndOfRecord());
        return fieldsRead;
    }

    public String read() throws IOException {
        int codePoint = 0;
        int codePointShift = 24;
        this.resetField();
        block24: while (true) {
            int code = this.in.read();
            if (this.bOffset > this.buffer.length - 2) {
                char[] b2 = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, b2, 0, this.bOffset);
                this.buffer = b2;
            }
            switch (code) {
                case -1: {
                    if (!this.endOfRecord) {
                        this.endOfRecord = true;
                        this.cleanEndOfRecord = false;
                    }
                    this.endOfStream = true;
                    return null;
                }
                case 10: {
                    if (!this.endOfRecord) {
                        this.endOfRecord = true;
                        this.cleanEndOfRecord = false;
                        return null;
                    }
                    this.endOfRecord = false;
                    continue block24;
                }
                case 37: {
                    this.endOfRecord = true;
                    this.cleanEndOfRecord = true;
                    return null;
                }
                case 58: {
                    this.bOffset = 0;
                    this.expecting = Expecting.FIELD_CONTENTS;
                    continue block24;
                }
                case 9: {
                    if (this.expecting != Expecting.FIELD_CONTENTS) {
                        this.resetField();
                        continue block24;
                    }
                    return new String(this.buffer, 0, this.bOffset);
                }
                case 13: {
                    continue block24;
                }
                case 92: {
                    if (this.expecting == Expecting.FIELD_CONTENTS) {
                        this.expecting = Expecting.ESCAPE_CODE;
                        continue block24;
                    }
                    if (this.expecting == Expecting.ESCAPE_CODE) break;
                    this.resetField();
                    continue block24;
                }
            }
            block9 : switch (this.expecting) {
                case START_OF_FIELD: {
                    break;
                }
                case FIELD_CONTENTS: {
                    if (code >= 32 && code <= 126) {
                        this.buffer[this.bOffset++] = (char)code;
                        break;
                    }
                    this.resetField();
                    break;
                }
                case ESCAPE_CODE: {
                    this.expecting = Expecting.FIELD_CONTENTS;
                    switch (code) {
                        case 92: {
                            this.buffer[this.bOffset++] = 92;
                            break block9;
                        }
                        case 110: {
                            this.buffer[this.bOffset++] = 10;
                            break block9;
                        }
                        case 112: {
                            this.buffer[this.bOffset++] = 37;
                            break block9;
                        }
                        case 99: {
                            this.buffer[this.bOffset++] = 58;
                            break block9;
                        }
                        case 116: {
                            this.buffer[this.bOffset++] = 9;
                            break block9;
                        }
                        case 114: {
                            this.buffer[this.bOffset++] = 13;
                            break block9;
                        }
                        case 117: {
                            this.expecting = Expecting.UNICODE_DIGIT;
                            codePoint = 0;
                            codePointShift = 24;
                            break block9;
                        }
                    }
                    this.resetField();
                    break;
                }
                case UNICODE_DIGIT: {
                    codePoint |= Character.getNumericValue(code) << (codePointShift -= 4);
                    if (codePointShift != 0) break;
                    this.bOffset += Character.toChars(codePoint, this.buffer, this.bOffset);
                    this.expecting = Expecting.FIELD_CONTENTS;
                }
            }
        }
    }

    static enum Expecting {
        START_OF_FIELD,
        FIELD_CONTENTS,
        ESCAPE_CODE,
        UNICODE_DIGIT;

    }
}

