(ns material-ui-reagent.pickers
  (:require
   ["@material-ui/pickers" :as mui-pickers]
   [goog.object :as go]
   [reagent.core :as reagent]))

(def pickers mui-pickers)

(defn- adapt
  "Make reagent component from @material-ui/pickers"
  [c]
  (reagent/adapt-react-class (go/get pickers c)))

(def MuiPickersUtilsProvider
  (adapt "MuiPickersUtilsProvider"))

(def DatePicker
  (adapt "DatePicker"))

(def TimePicker
  (adapt "TimePicker"))

(def DateTimePicker
  (adapt "DateTimePicker"))

(def KeyboardDatePicker
  (adapt "KeyboardDatePicker"))

(def KeyboardTimePicker
  (adapt "KeyboardTimePicker"))

(def KeyboardDateTimePicker
  (adapt "KeyboardDateTimePicker"))
