(ns toy-app.web.helper
  "common functions to be called by the web app, this ns should have very few internal dependencies"
  (:use
    [toy-app.web.templates]
    [hiccup.core]
    [compojure.core]
    [ring.util.response]
    [ring.middleware.session.cookie]
    [ring.middleware.session]
    [ring.middleware.stacktrace]
    [ring.middleware.resource]
    [ring.middleware.file-info]))

(defn add-to-session [rsp session vars]
  (let [new-session (merge session vars)]
    (assoc rsp :session new-session)))

(defmacro defpage [name & body]
  `(defn ~name [req#]
     (let [{~'params :params ~'session :session} req#]
       (layout ~'session (do ~@body)))))

(defmacro defpage-no-layout [name & body]
  `(defn ~name [req#]
     (let [{~'params :params ~'session :session} req#]
       ~@body)))

(defn wrap-verify-loggedin
  "Verify that user is logged in unless homepage"
  [handler]
  (fn [request]
    (if (-> request :session :uid nil?)
      (ring.util.response/redirect "/")
      (handler request))))

(defn wrap-failsafe [handler]
  (fn [req]
    (try
      (handler req)
      (catch Exception e
        (println e)
        {:status 500
         :headers {"Content-Type" "text/plain"}
         :body "We're sorry, something went wrong."}))))


(defn wrap-if
  "middleware to conditionally turn on other middleware given a condition"
  [handler pred wrapper & args]
  (if pred
    (apply wrapper handler args)
    handler))
