(ns toy-app.web.auth
  "user facing portion of the app"
  (:require [oauth.client :as oauth])
  (:require [compojure.route :as route])
  (:use
    [toy-app.core]
    [toy-app.config]
    [toy-app.time]
    [toy-app.web.templates]
    [toy-app.web.helper]
    [toy-app.utility]
    [korma.db]
    ;[clostache.parser]
    [hiccup.core]
    [compojure.core]
    [ring.util.response]
    [ring.middleware.session.cookie]
    [ring.middleware.session]
    [ring.middleware.stacktrace]
    [ring.middleware.resource]
    [ring.middleware.file-info]
    ;   [ring.middleware.logger]
    [korma.core])
  (:use [ring.adapter.jetty])
  (:use [ring.middleware params reload])
  (:use [ring.util.codec :only [url-encode]])
  (:gen-class))




(def consumer (oauth/make-consumer (app-config :appkey)
                                   (app-config :appsecret)
                                   "http://api.twitter.com/oauth/request_token"
                                   "http://api.twitter.com/oauth/access_token"
                                   "http://api.twitter.com/oauth/authenticate"
                                   :hmac-sha1))


(defn request-token [] (oauth/request-token consumer (app-config :callback)))


(defpage-no-layout authorize
  (let [rt (request-token)
        email (params "email")]
    (if (:uid session)
      (->
        (ring.util.response/redirect "/")
        (cond-> (not (empty? email)) (add-to-session session {:email email})))
      (->
        (ring.util.response/redirect (oauth/user-approval-uri consumer (:oauth_token rt)))
        (add-to-session session {:request-token rt})
        ))))

(defpage-no-layout callback
  (let [oauth_token (params "oauth_token")
        oauth_verifier (params "oauth_verifier")
        rt (:request-token session)
        access-token-response (oauth/access-token consumer rt oauth_verifier)
        uid (:user_id access-token-response)
        oauth_token (:oauth_token access-token-response)
        oauth_token_secret (:oauth_token_secret access-token-response)
        screen-name (:screen_name access-token-response)
        ]
    (when (nil? (user-find uid))
      (create-user uid oauth_token oauth_token_secret screen-name))
    (-> (ring.util.response/redirect "/") (add-to-session session {:uid uid}))))

(defpage-no-layout logout
  (-> (ring.util.response/redirect "/") (assoc :session {:uid nil})))

(defpage-no-layout create-user-api
  ;TODO add proper return code 200, or fail, add ability to allow apps to pass credentials
  (if (params "app")
    (create-user (params "id") (params "usertoken") (params "usersecret") (params "screen_name") (params "apptkoen") (params "appsecret"))
    ))



















(defpage home
  (let [referer-string (when (params "fid") (str "&fid=" (params "fid")))]
  [:div#wrapper.clearfix
   [:div.jumbotron
    [:div.row
     [:div.col-md-8
      [:h2#home_head.featured-title "Fresh Content, Tweeted for You"]
      [:ul.normal_line_height
        [:li  "Set it up once, fresh tweets always." ]
        [:li "Analytics to help you learn what works best."]
        [:li "Save time, get more done!"]
      ]
      [:div.call-to-action
       [:a.btn.btn-lg.btn-warning {:href (str "/authorize" referer_string)}
        "<b>Get Started!</b>"]
        ]
       ]
     [:div#hero-image.col-md-4.offset1
      [:img.aligncenter {:src "img/twitter_bird_jetpack_orange.jpg"
                         :width "275"
                         :alt ""}]
     ] ]]]))

(defroutes user-router
  (GET "/callback" [] callback)
  (ANY "/authorize" [] authorize)
  (GET "/logout" [] logout))



