(ns toy-app.web.admin
  (:use
    [toy-app.web.helper]
    [toy-app.web.templates]
    [pusher.core]
    [pusher.time]
    [compojure.core]
    [clostache.parser]
        )
  (:require [compojure.route :as route])
  )

(defn id-to-twitter-url [id]
  (str "http://twitter.com/account/redirect_by_id?id=" id))

(defn user-to-table-row [u]
  [:tr
    [:td
      [:a {:name (u :id) :href (id-to-twitter-url (:id u)) }
               " "
               "@" (:screen_name u)]
            [:p.smaller (:email u) " | " (:id u )
               [:br] "Joined " (mdy-date (:at u))]]
    [:td
      [:a.small {:href (str "/admin/user?id=" (:id u))} "[View details]"]
    ]])



(defpage admin-users)

(defpage admin-user)

(defn login-as [id])

(defroutes admin-router
  (GET "/admin" [] admin)
  (GET "/admin/users" [] admin-users)
  (GET "/admin/user" [] admin-user)
  (GET "/admin/as"  [] login-as))
