(ns toy-app.time
  (:use
    [toy-app.config]
    [toy-app.utility]
    [clj-time.core :exclude [extend]]
    [clj-time.coerce]
    [clj-time.format]
    ))

(defn now-long [] (to-long (now)))

(defn days-old
  "given a long timestamp, calculate how many days old the account is"
  [long-time]
  (let [diff (- (now-long) long-time)]
    (int (/ diff 86400000))))

(defn localize-long [long-ts]
  (let [hour 3600000 ;; (* 1000 60 60)
        time-shift (* hour app-time-zone)]
    (+ long-ts time-shift)))

(defn utc->local-time-str [time-long format]
  (unparse format (-> time-long localize-long from-long)))

(defn display-time [t]
  (utc->local-time-str t (formatter "hh:mm:ss aaa, MM/dd/yyyy")))

(defn mdy-date [long-unix-timestamp]
  (try (let [date_time (-> long-unix-timestamp localize-long from-long)
            string (unparse (formatter "MM/dd/YYYY") date_time)]
            string)
   (catch Exception _ nil)))
