(ns toy-app.notifications
  "responsible for sending emails,hipchat messages, and other forms of messages"
  (:use [postal.core]
        [toy-app.config])
  (:require [org.httpkit.client :as httpkit]))

(defn notify?
  "only send notifications when the app-config has :notify set"
  [method]
  (when
    (and
      (:notify app-config) (method app-config))))


(defn email [from to subject message]
  (when (notify? :email)
    (let [msg (with-meta {:from from
                          :to to
                          :subject subject
                          :body message}
              {:host (app-config :smtp-host)
               :user (app-config :smtp-user)
               :pass (app-config :smtp-pass)
               :ssl :true})
          ]
    (if production?
      (send-message msg)
      (str "in " environment ", simulating sending email: " msg)))))

(defn hipchat
  ([message] (hipchat message "dev"))
  ([message room]
    (if (notify? :hipchat)
      (let [options {:form-params {:room_id room :from "dev" :message message :notify 1}}]
        @(httpkit/post (str "https://api.hipchat.com/v1/rooms/message?format=html&auth_token=5aa747c6f10d1a01bf5f6020634d7c") options)))))

(defn email-admins [subject message] (email (app-config :team-email)  (app-config :team-email) subject message))

