(ns toy-app.config
  (:require [cheshire.core :refer :all]))


;used fields:
;name:        name of the site
;site:        url of the site
;smtp-host:   address for server
;smtp-user:   username for smtp server
;smtp-pass:   password for smtp server
;callback:    callback url for twitter oauth
;team-email:  email address to send to regarding company concerns
;twitter:     twitter account to use

;the app-config is stored in a clojure map on file in resources
(def app-config
 (try
   (read-string (slurp (clojure.java.io/resource "config")))
   (catch Exception e (do (println (str "warning, unable to read config:" e)) {}))
   ))


(def environment (get (System/getenv) "APP_ENV" "development"))

(def production?
  (= "production" environment))

(def test?
  (= "test" environment))

;default is development
(def development?
  (= "development" environment))

(def app-time-zone
  (if (:time-zone app-config)
    (:time-zone app-config)
    -4))

