(ns tidy.macros
  (:require [clojure.core.async :as core-async]))

;;; Declarations

(declare throw-err)

;;; API

(defmacro <? [ch]
  `(throw-err (core-async/<! ~ch)))

(defmacro go? [& body]
  `(core-async/go
     (try (do ~@body)
          (catch Exception e#
            e#))))

(defmacro <?? [ch]
  `(throw-err (core-async/<!! ~ch)))

(defmacro thread? [& body]
  `(core-async/thread
     (try (do ~@body)
          (catch Exception e#
            e#))))

;;; Private

(defn throwable?
  [e]
  (instance? Throwable e))

(defn throwable
  [e]
  (when-let [e (or (and (throwable? e) e)
                   (and (coll? e)
                        (first (filter throwable? e))))]
    (throw e)))

(defn throw-err [e]
  (when (throwable e) (throw e))
  e)
