(ns re-frame-auth.protocols)

(defprotocol TokenGenerator
  (generate [this data])
  (parse
    [this token]
    [this token opts])
  (expiry-time-ms [this]))

(defprotocol AuthenticationFlow
  (authenticate [this request]))

(defprotocol RefreshFlow
  (refresh [this request]))

(defprotocol UserStore
  (find-user [this user-id])
  (create-user! [this user])
  (delete-user! [this user-id]))

(defprotocol AuthStore
  (find-auth [this auth])
  (create-auth! [this auth])
  (delete-auth! [this auth])
  (create-refresh-token! [this claims])
  (revoke-refresh-token! [this claims])
  (refresh-token-revoked? [this claims]))
