(ns re-frame-auth.util.spec
  (:require [clojure.spec.alpha :as s]
            [spec-tools.core :as st]
            [expound.alpha :as expound]))

(defn validate
  [spec x]
  (if (s/valid? spec x) x
      (throw
       (ex-info
        (expound/expound-str spec x)
        {:form x}))))

(defn scrub
  [spec x]
  (let [scrubbed (when (map? x)
                   (st/select-spec spec x))]
    (if (map? scrubbed)
      scrubbed
      (if (= scrubbed :clojure.spec.alpha/invalid)
        (throw
         (ex-info
          (expound/expound-str spec x)
          {:form x}))
        (throw (ex-info "Unable to scrub"
                        {:x x
                         :scrubbed scrubbed
                         :spec spec}))))))
