(ns re-frame-auth.util.email
  (:require [qbits.thorn :as thorn]
            [clojure.string :as st]))

;;; Declarations

(declare valid-email?)

;;; API

(defn normalize
  [email]
  (let [original-email email
        email (st/lower-case email)
        [local domain] (st/split email #"\@")
        local (-> local
                  (st/replace #"\." "")
                  (st/split #"\+")
                  first)
        normalized (str local "@" domain)]
    {:local local
     :domain domain
     :original original-email
     :normalized normalized
     :valid? (valid-email? normalized)
     :dangerous? (boolean (thorn/dangerous? local))}))

;;; Private

(def ^:private email-pattern #"[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?")

(defn- valid-email?
  [email]
  (boolean (and (string? email) (re-matches email-pattern email))))
