(ns re-frame-auth.fx.http
  (:require [taoensso.encore :as enc]
            [re-frame.core :refer [reg-event-fx reg-fx reg-sub dispatch]]
            [utilis.types.string :refer [->string]]
            [utilis.types.keyword :refer [->keyword]]
            [utilis.map :refer [compact map-keys]]
            [clojure.string :as st]))

(reg-fx
 :auth-fx/http
 (fn [{:keys [method headers params url on-success on-failure timeout-ms method]
      :or {timeout-ms 5000
           method :get}}]
   (try (enc/ajax-lite
         url
         (compact
          {:method method
           :headers headers
           :params params
           :timeout-ms timeout-ms})
         (fn [ajax-response]
           (let [status (:?status ajax-response)
                 success? (or (<= 200 status 299)
                              (<= 300 status 399))
                 response {:status status
                           :headers (when-not (zero? status)
                                      (when-let [xhr (:xhr ajax-response)]
                                        (when-let [headers (.getResponseHeaders xhr)]
                                          (map-keys
                                           #(-> % ->string st/lower-case ->keyword)
                                           (js->clj headers :keywordize-keys true)))))
                           :body (:?content ajax-response)
                           :success? success?
                           :_response ajax-response}]
             (if success?
               (when (vector? on-success)
                 (dispatch (conj on-success response)))
               (when (vector? on-failure)
                 (dispatch (conj on-failure response)))))))
        (catch js/Error e
          (when (vector? on-failure)
            (dispatch (conj on-failure e)))))))
