(defproject tomthought/re-frame-auth "0.4.2"
  :description "Opinionated authentication flow in re-frame"
  :url "https://github.com/tomthought/re-frame-auth"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/core.async "0.4.474"]
                 [com.7theta/utilis "1.1.0"]
                 [buddy/buddy-auth "2.1.0"]
                 [buddy/buddy-hashers "1.3.0"]
                 [tomthought/rethink "0.1.2-alpha"]
                 [danlentz/clj-uuid "0.1.7"]
                 [org.clojure/data.json "0.2.6"]
                 [cc.qbits/thorn "0.1.0"]
                 [com.taoensso/encore "2.96.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [metosin/spec-tools "0.7.0"]
                 [alandipert/storage-atom "2.0.1"]
                 [re-frame "0.10.5"]
                 [integrant "0.6.3"]

                 [com.google.firebase/firebase-admin "6.1.0"
                  :exclusions [org.slf4j/slf4j-log4j12 log4j/log4j]]

                 ]
  :source-paths ["src/clj" "src/cljs"]
  :clean-targets ^{:protect false} ["target"]
  :profiles {:dev {:source-paths ["dev/clj"]
                   :figwheel {:server-port 5005}
                   :dependencies [[binaryage/devtools "0.9.10"]
                                  [http-kit "2.3.0"]
                                  [ring/ring-core "1.6.3"]
                                  [ring/ring-defaults "0.3.1"]
                                  [bk/ring-gzip "0.3.0"]
                                  [compojure "1.6.1"]
                                  [figwheel-sidecar "0.5.16"]
                                  [com.cemerick/piggieback "0.2.2"]
                                  [integrant "0.6.3"]
                                  [integrant/repl "0.3.1"]
                                  [reagent "0.8.1"]
                                  [expound "0.5.0"]]
                   :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   :plugins [[lein-cljsbuild "1.1.7" :exclusions [org.apache.commons/commons-compress]]
                             [lein-figwheel "0.5.15" :exclusions [org.clojure/clojure]]]}}
  :cljsbuild {:builds [{:id "dev"
                        :source-paths ["src/cljs" "dev/cljs"]
                        :figwheel {:on-jsload "auth-fx.setup/mount-root"}
                        :compiler {:main re-frame-auth.setup
                                   :output-to "dev-resources/public/js/compiled/app.js"
                                   :output-dir "dev-resources/public/js/compiled/out"
                                   :asset-path "js/compiled/out"
                                   :source-map-timestamp true
                                   :preloads [devtools.preload]
                                   :external-config {:devtools/config {:features-to-install :all}}}}]}
  :prep-tasks ["compile"])
