(ns hub.security
  (:require [clj-uuid :refer [v4]]

            [buddy.core.hash :as hash]
            [buddy.core.codecs :as cd]

            [clojure.string :as st]))

;;; Declarations

(declare remove-dashes)

;;; Public

(defn uuid
  []
  (remove-dashes (str (v4))))

(defn sha1
  [x]
  (cd/bytes->hex (hash/sha1 x)))

;;; Private

(defn- remove-dashes
  [s]
  (st/replace s #"-" ""))
