(ns hub.cli
  (:require [utilis.types.keyword :refer [->keyword]]
            [utilis.types.number :refer [string->long]]))

;;; Declarations

(declare coerce)

;;; Public

(defn parse-command-line-args
  [args]
  (->> args
       (partition 2)
       (map (fn [[k v]] [(->keyword k) (coerce v)]))
       (into {})))

;;; Private

(defn- coerce
  [v]
  (or (cond
        (= v "true") true
        (= v "false") false
        :else (string->long v))
      v))
