(ns currency.round
  "Good reference for behaviour here https://docs.oracle.com/javase/7/docs/api/java/math/RoundingMode.html"
  (:require [clojure.spec.alpha :as s]))

;;; Declarations

(def ^:private round* #?(:clj #(Math/round ^Double (double %))
                         :cljs js/Math.round))
(def ^:private ceil* #?(:clj #(Math/ceil ^Double (double %))
                        :cljs js/Math.ceil))
(def ^:private floor* #?(:clj #(Math/floor ^Double (double %))
                         :cljs js/Math.floor))

;;; API

(defn half-up
  [n]
  {:pre [(s/valid? ::number n)]}
  (long (round* (double n))))

(defn ceil
  [n]
  {:pre [(s/valid? ::number n)]}
  (long (ceil* (double n))))

(defn floor
  [n]
  {:pre [(s/valid? ::number n)]}
  (long (floor* (double n))))

;;; Specs

(s/def ::number (s/and number? #(>= % 0)))
