(ns currency.coerce
  (:require [currency.core :as currency]
            [utilis.types.string :refer [->string]]
            [utilis.types.keyword :refer [->keyword]]
            [utilis.map :refer [map-vals]]))

;;; API

(defn coerce
  [m]
  (when (and (:currency m)
             (:amount m)
             (= 2 (count (keys m))))
    (currency/monetary-unit
     (->keyword (:currency m))
     (:amount m))))

(defn coerce-walk
  [m]
  (cond

    (map? m)
    (or (coerce m)
        (map-vals coerce-walk m))

    (coll? m)
    (->> m (map coerce-walk)
         (into (empty m)))

    :else m))
