(defproject tokomakoma123/enfocus "2.0.0-SNAPSHOT"
  :description "DOM manipulation tool for clojurescript inspired by Enlive"
  :url "http://ckirkendall.github.io/enfocus-site"
  :license {:name "Eclipse Public License - v 1.0"
            :url "http://www.eclipse.org/legal/epl-v10.html"
            :distribution :repo}

  :min-lein-version "2.2.0"

  :source-paths ["src/clj" "src/cljs"]
  :test-paths ["test/clj" "test/cljs"]

  :dependencies [[org.clojure/clojure "1.5.1"]
                 [org.clojure/clojurescript "0.0-2069"]
                 ;;[org.clojure/clojurescript "0.0-2202"]
;                 [domina "1.0.2"]
                 [domina "1.0.3-SNAPSHOT"]
                 [org.jsoup/jsoup "1.7.2"]
                 ]

  :plugins [
            [lein-cljsbuild "1.0.0"]
            ;[lein-cljsbuild "1.0.3"]
            [com.cemerick/clojurescript.test "0.2.1"]
            ]  
  :hooks [leiningen.cljsbuild]

  :cljsbuild
  {:crossovers [enfocus.enlive.syntax]
   :crossover-jar true
   ;; we moved all the builds to support unit testing into the dev profile.
   ;; Here we only define the one used for including the lib CLJS source files
   ;; in the jar package.
   :builds {:deploy
            {:source-paths ["src/cljs"]
             ;:jar true ; DON'T TO THIS
             :compiler
             {:output-to "dev-resources/public/js/deploy.js"
              :optimizations :none
              :pretty-print false}}}}
  :profiles {:dev {:test-paths ["test/clj" "test/cljs"]
                   :dependencies [[com.cemerick/piggieback "0.1.2"]]
                   :plugins [[com.cemerick/clojurescript.test "0.2.1"]]

                   :cljsbuild
                   {:builds {:whitespace
                             {:source-paths ["src/cljs" "test/cljs"]
                              :compiler
                              {:output-to "dev-resources/public/js/whitespace.js"
                               :optimizations :whitespace
                               :pretty-print true}}

                             :simple
                             {:source-paths ["src/cljs" "test/cljs"]
                              :compiler
                              {:output-to "dev-resources/public/js/simple.js"
                               :optimizations :simple
                               :pretty-print false}}

                             :advanced
                             {:source-paths ["src/cljs" "test/cljs"]
                              :compiler
                              {:output-to "dev-resources/public/js/advanced.js"
                               :optimizations :advanced
                               :pretty-print false}}}

                    :test-commands {"whitespace"
                                    ["phantomjs" :runner "dev-resources/public/js/whitespace.js"]

                                    "simple"
                                    ["phantomjs" :runner "dev-resources/public/js/simple.js"]

                                    "advanced"
                                    ["phantomjs" :runner "dev-resources/public/js/advanced.js"]}}
                   
                   :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   :injections [(require '[cljs.repl.browser :as brepl]
                                         '[cemerick.piggieback :as pb])
                                (defn browser-repl []
                                  (pb/cljs-repl :repl-env
                                                (brepl/repl-env :port 9000)))]}

})



