(ns tlight.test
  (:require [clojure.core.async :as async :refer [>!! go-loop alt! timeout chan]]))

(def done? (atom (chan)))

(defn done []
  (>!! @done? true))

(defn spin [& {:keys [type template ms]
               :or   {type :box1, template "ok %s", ms 200}}]
  "The spin function loops a spinner to STDOUT until a call to (done)"
  (let [s "⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏" length 4]
    (go-loop [i 0]
      (let [c   (get s i)
            i++ (mod (+ i 1) length)
            out (format template c)
            pre (format "\033[%sD" (count out))]
        (print (str pre out))
        (flush)
        (alt! @done? :done, (timeout ms) (recur i++))))))

(defn work[] (Thread/sleep 100))
(defn main[]
  (print "spin!")
  (spin)
  (Thread/sleep 3000)
  (print "done!")
  (done))

(main)
