(defproject timgluz/elastisch "2.2.1"
  :url "http://clojureelasticsearch.info"
  :description "just test release to test suggester feature;"
  :license {:name "Eclipse Public License"}
  :dependencies [[org.clojure/clojure   "1.7.0"]
                 [cheshire              "5.5.0"]
                 [clj-http              "2.0.0" :exclusions [org.clojure/clojure]]
                 [clojurewerkz/support  "1.1.0" :exclusions [com.google.guava/guava]]
                 ;; used by the native client
                 [org.elasticsearch/elasticsearch "1.7.2"]]
  :min-lein-version "2.5.1"
  :profiles     {:dev {:resource-paths ["test/resources"]
                       :dependencies [[clj-time "0.9.0" :exclusions [org.clojure/clojure]]]
                       :plugins [[codox           "0.8.12"]
                                 [jonase/eastwood "0.2.1"]]
                       :codox {:sources ["src"]
                               :output-dir "doc/api"}}
                 ;; this version of clj-http depends on HTTPCore 4.2.x which
                 ;; some projects (e.g. using Spring's RestTemplate) can rely on,
                 ;; so we test for compatibility with it. MK.
                 :cljhttp076 {:dependencies [[clj-http "0.7.6"]]}
                 :1.7 {:dependencies [[org.clojure/clojure "1.7.0-beta3"]]}
                 :master {:dependencies [[org.clojure/clojure "1.8.0-master-SNAPSHOT"]]}}
  :aliases      {"all" ["with-profile" "dev:dev,1.7:dev,cljhttp076"]}
  :global-vars {*warn-on-reflection* true}
  :test-selectors {:focus       :focus
                   :indexing    :indexing
                   :query       :query
                   :facets      :facets
                   :percolation :percolation
                   :scroll      :scroll
                   :snapshots   :snapshots
                   :native      :native
                   :rest        :rest
                   :version-dependent :version-dependent
                   :all         (constantly true)
                   :default     (fn [m] (not (or (:version-dependent m)
                                                 (:scripting m))))
                   :ci          (fn [m] (and (not (:native m)) (not (:version-dependent m))))}
  :mailing-list {:name "clojure-elasticsearch"
                 :archive "https://groups.google.com/group/clojure-elasticsearch"
                 :post "clojure-elasticsearch@googlegroups.com"})
