(ns tiesql.tools.http-server
  (:require [immutant.web :as im]
            [clojure.tools.logging :as log]
            [com.stuartsierra.component :as component]))


#_(defn start [routes port]
  (im/run routes {:port port}))



(defrecord Server [port routes]
  component/Lifecycle
  (start [component]
    (log/info "Starting server  ")
    (let [server (im/run (:routes routes) {:port port})]
      (log/info "Starting server done  with port....... " port)
      (assoc component :server server)))
  (stop [component]
    (log/info "Stoping server.........")
    (let [server (:server component)]
      (if server
        (do
          (im/stop server)
          (assoc component :server nil))
        component))))


(defn new-server [port]
  (map->Server {:port port}))




