(ns tiesql.common
  (:require [clojure.tools.logging :as log]
            [clj-common :refer :all]
            [schema.core :as s]))


;;;;;;;;;;;;;;;;;;;;;; Process keyword

;(def k-schema-root :k-schema-root)
(def k-merge :k-merge)
(def k-name :k-name)
(def k-order :k-order)

(def k-validate :k-validate)
(def k-emission :k-emission)

(def k-schema-validate :k-schema-validate)
(def k-process-type :k-process-type)
(def k-process :k-process)
(def k-join :k-join)
(def k-disjoin :k-disjoin)

(def childs :childs)

;;;;;;;;;;;;;;;;;;; Schema keyword ;;;;;;;;;;;;;;;;;;;;;;;;;;
(defonce global-key :_global_)
(defonce process-context-key :process-context)
(defonce reserve-name-key :reserve-name)
(defonce file-name-key :file-name)
(defonce file-reload-key :file-reload)
(defonce ds-key :datasource)
(defonce ds-conn-key :datasource-conn)
(defonce tx-prop :tx-prop)


(defonce name-key :name)
(defonce column-key :column)
(defonce doc-key :doc)
(defonce model-key :model)
(defonce skip-key :skip)
(defonce timeout-key :timeout)
(defonce group-key :group)
(defonce index :index)
(defonce sql-key :sql)


;(def root-meta :meta)
(defonce extend-meta-key :extend)

;(def meta-with-extend #{root-meta extend-meta-key})

(def model-type :model)
(def map-type :default)



(defonce params-key :params)
(defonce params-ref-con-key :ref-con)
(defonce params-ref-key :ref-key)
(defonce params-ref-fn-key :ref-fn-key)
(defonce params-ref-gen-key :ref-gen)


(defonce validation-key :validation)
(def vali-type :type)
(def vali-range :range)
(def vali-contain :contain)


(defonce join-key :join)
(defonce join-1-1-key :1-1)
(defonce join-1-n-key :1-n)
(defonce join-n-1-key :n-1)
(defonce join-n-n-key :n-n)


(defonce dml-type-key :dml-type)
(defonce dml-type-select-key :select)
(defonce dml-type-insert-key :insert)
(defonce dml-type-update-key :update)
(defonce dml-type-delete-key :delete)
(defonce dml-type-call-key :call)



(defonce commit-key :commit)
(defonce commit-all-key :all)
(defonce commit-any-key :any)
(defonce commit-none-key :none)



(defonce result-key :result)
(defonce result-array-key :array)
(defonce result-single-key :single)



(defonce bind-type-key :bind-type)
(defonce output-key :output)
(defonce input-key :input)
(defonce error-key :error)
;(defonce error-key :error)
(defonce exec-time-key :exec-time)
(defonce query-exception-key :query-exception)



(def pre-in-step :pre-in-step)
(def post-in-step :post-in-step)
(def pre-out-step :pre-out-step)
(def post-out-step :post-out-step)



(def ProcessSchema {(s/optional-key k-validate)        {s/Any s/Any}
                    ;(s/optional-key k-schema-root)     s/Any
                    ;(s/optional-key k-merge)           (s/pred fn? 'CheckFunction)
                    (s/required-key k-name)            s/Keyword
                    (s/optional-key k-order)           s/Int
                    (s/optional-key k-process-type)    s/Any
                    ;(s/optional-key k-resolve)         s/Any
                    (s/optional-key k-schema-validate) s/Any
                    (s/optional-key k-process)         (s/pred fn? 'CheckFunction)})



(defn debug
  ([m] (debug "" m))
  ([msg m]
   (let [msg (str msg m)]
     (log/info msg))
   m))










