(defproject tiesql/client-cljs "0.1.0-alpha-SNAPSHOT"
  :description "It is clojure script client for tiesql framework "
  :url "https://github.com/Mamun/tiesql"
  :license {:alias "Eclipse Public License"
            :url   "http://www.eclipse.org/legal/epl-v10.html"}
  :scm {:dir ".."}

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                 [org.clojure/clojurescript "1.7.170"]
                 [com.cognitect/transit-cljs "0.8.225"]
                 [cljs-http "0.1.37"]
                 ;[cljs-ajax "0.3.14"]
                 ;[reagent "0.5.0"]
                 ;[reagent-forms "0.5.1"]
                 ]

  :clean-targets ^{:protect false} ["resources-dev/public/js/compiled"
                                    "target"
                                    :target-path]

  :plugins [[lein-cljsbuild "1.1.1"]]

  :profiles {:dev {:repl-options   {:port 4555}
                   :source-paths   ["dev"]
                   :resource-paths ["resources-dev/"]
                   :dependencies   [[json-html "0.2.9"]
                                    [sablono "0.4.0"]
                                    [devcards "0.2.1-2"]
                                    [tiesql/core "0.1.0-alpha-SNAPSHOT"]
                                    [tiesql/server "0.1.0-alpha-SNAPSHOT"]
                                    [ch.qos.logback/logback-classic "1.1.3"]
                                    [com.h2database/h2 "1.3.154"]

                                    [figwheel-sidecar "0.5.0-2"]

                                    ;[figwheel-sidecar "0.4.1"]
                                    ]}}
  :cljsbuild {:builds {:devcard {:source-paths ["src" "src-dev"]
                                 :compiler     {:output-to     "resources-dev/public/js/compiled/tiesql-dev.js"
                                                :optimizations :whitespace
                                                :pretty-print  false}}
                       :dev     {:source-paths ["src" ]
                                 :jar          true
                                 :compiler     {:output-to     "resources-dev/public/js/compiled/tiesql-debug.js"
                                                :optimizations :whitespace
                                                :pretty-print  true}}
                       :prod    {:source-paths ["src" ]
                                 :compiler     {:output-to     "resources-dev/public/js/compiled/tiesql-min.js"
                                                :optimizations :advanced
                                                :pretty-print  false}}}})
