(ns tiesql.client
  (:require [clj-http.client :as client]
            [clojure.tools.reader.edn :as edn]))


(defn make-request
  [name-coll params]
  (let [v {:name   name-coll
           :params params}]
    {:form-params  v
     :as           :transit+json
     ;:accept        :edn
     :accept       :transit+json
     :content-type :transit+json}))


(defn call-http-service
  [url req]
  (let [res (client/post url req)]
    (if (= (:status res)
           200)
      (:body res)
      [nil res])))


(defn error?
  [name-coll params]
  (cond
    (not (sequential? name-coll))
    [nil "Name will be sequential"]
    (not (map? params))
    [nil "Param will be map"]
    :else
    false))

(defn pull-batch!
  [& {:keys [url name params]
      :or   {params {}}}]
  (if-let [e (error? name params)]
    e
    (->> (make-request name params)
         (call-http-service (str url "/pullbatch")))))


(defn push-batch!
  [& {:keys [url name params]}]
  (if-let [e (error? name params)]
    e
    (->> (make-request name params)
         (call-http-service (str url "/pushbatch")))))




