(ns appkit.reconciler
  #?(:clj
     (:require [appkit.citrus.core :as citrus])

     :cljs
     (:require [appkit.citrus.core :as citrus]
               [appkit.effects :as effects]
               [appkit.db      :as db]
               [appkit.storage :as storage]
               [goog.net.cookies])))

#?(:cljs
   (defonce effect-handlers (atom {:http          effects/http
                                   :local-storage effects/local-storage
                                   :cookie        effects/cookie
                                   :redirect      effects/redirect
                                   :dispatch      effects/dispatch
                                   :timeout       effects/timeout})))

(defn reconciler [handler]
  #?(:clj
     (citrus/reconciler
       {:state     (atom {})})
     :cljs
     (citrus/reconciler
       {:state           db/state
        :handler         handler
        :effect-handlers effect-handlers})))
