(ns tieboot
  (:require
    [com.stuartsierra.component :as component]
    [immutant.web :as im]
    [clojure.tools.logging :as log]
    [tiesql.system :refer :all])
  (:gen-class))


(defrecord Server [config routes]
  component/Lifecycle
  (start [component]
    (log/info "Starting server  ")
    (let [{:keys [port routes-path]} (:config config)
          server (-> (tie-app-routes component routes-path)
                     (im/run {:port port}))]
      (log/info "Starting server done  with port....... " port)
      (assoc component :server server)))
  (stop [component]
    (log/info "Stoping server.........")
    (let [server (:server component)]
      (if server
        (do
          (im/stop server)
          (assoc component :server nil))
        component))))


(defn new-server []
  (map->Server {}))


(defn boot-system
  []
  (-> (component/system-map
        :config (new-config)
        :db (new-db)
        :routes (new-routes)
        :server (new-server))
      (component/system-using
        {:db     {:config :config}
         :routes {:config :config
                  :db     :db}
         :server {:config :config
                  :routes :routes}})))

(defn boot []
  (->> (boot-system)
       (component/start)))


(defn -main [& args]
  (println "Starting tie app  ")
  (boot))
