(ns tiesql.tools.ds
  (:require [tiesql.common :as sc]
            [clojure.tools.logging :as log]
            [clj-common :as cc]
            ))




(defprotocol IDataSource
  (k-create [this])
  (k-connection [this])
  (k-close [this])
  (k-status [this]))


(defn create
  [ds-impl]
  (if-not (satisfies? IDataSource ds-impl)
    (do
      (log/info "Data source creation failed, ds-impl does not satisfied IDataSource ")
      (cc/fail "Data source creation failed, ds-impl does not satisfied IDataSource "))
    (let [ds (k-create ds-impl)]
      ds)))


(defn close
  [ds-impl]
  (try
    (when (satisfies? IDataSource ds-impl)
      (k-close ds-impl)
      (log/info "Database connection closed successfully "))
    (catch Exception e
      (log/error e))))


(defn connection
  [ds-impl]
  (when (satisfies? IDataSource ds-impl)
    {:datasource (k-connection ds-impl)}))


(defn status
  [ds-impl]
  (when (satisfies? IDataSource ds-impl)
    (k-status ds-impl)))
