(defproject tie/tiesql-server "0.1.0-alpha-SNAPSHOT"
  :description "Clojure database access framework"
  :url "https://github.com/Mamun/chackathon"
  :license {:alias "Eclipse Public License"
            :url   "http://www.eclipse.org/legal/epl-v10.html"}
  :scm {:dir ".."}

  :offline? true

  ;:source-paths ["src/clj"]
  :resource-paths []
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                 [org.clojure/data.json "0.2.6"]

                 [com.stuartsierra/component "0.2.3"]
                 [ring "1.4.0"
                  :exclusions [ring/ring-jetty-adapter
                               ring/ring-devel]]

                 [cheshire "5.4.0"]
                 [commons-codec "1.8"]
                 [com.cognitect/transit-clj "0.8.269"]
                 [ring-middleware-format "0.6.0"
                  :exclusions [ring
                               org.clojure/core.memoize
                               org.clojure/tools.reader
                               com.cognitect/transit-clj
                               cheshire]]
                 [compojure "1.1.6"]

                 [c3p0/c3p0 "0.9.1.2"]

                 [org.immutant/web "2.1.0"                  ;; default Web server
                  :exclusions [ch.qos.logback/logback-core
                               org.slf4j/slf4j-api]]]

  :profiles {:dev  {:repl-options   {:port 4555}
                    :source-paths   ["dev"]
                    :resource-paths ["resources-dev/"]
                    :dependencies   [[org.clojure/tools.namespace "0.2.11"]
                                     [org.clojure/tools.nrepl "0.2.10"]
                                     [com.h2database/h2 "1.3.154"]
                                     [ch.qos.logback/logback-classic "1.1.3"]
                                     [tie/tiesql "0.1.0-alpha-SNAPSHOT"]]}
             ;export LEIN_SNAPSHOTS_IN_RELEASE=1
             :prod {:main         tieboot
                    :aot          [tieboot]
                    :dependencies [[ch.qos.logback/logback-classic "1.1.3"]
                                   [tie/tiesql "0.1.0-alpha-SNAPSHOT"]]
                    :uberjar-name "tiesql-boot.jar"
                    :manifest     {"Class-Path" "lib lib/*"}}})

