(ns tiesql.client
  (:import [goog.net EventType ErrorCode XhrIo]
           [goog.net Jsonp])
  (:require [cljs-http.client :as http]
            [cljs.core.async :as async :refer [chan close!]])
  (:require-macros [cljs.core.async.macros :refer [go alt!]]))


(defn log [s]
  (.log js/console (str s)))


(defn build-request
  [name-coll params-map options]
  (let [v {:name    name-coll
           :options (merge {:input  :keyword
                            :output :keyword} (or options {}))
           :params  params-map}]
    {:with-credentials? false
     :accept            "application/transit+json"
     ;:accept            "application/edn"
     :transit-params    v}))


(defn error?
  [name-coll params options]
  (cond
    (not (sequential? name-coll))
    [nil "Name will be sequential"]
    (not (map? params))
    [nil "Param will be map "]
    (not (map? options))
    [nil "Option will be map "]
    :else false))


(defn call-http-service
  [req url-str callback]
  (go
    (let [res (->> req
                   (http/post url-str)
                   (async/<!))]
      (if (and (:success res)
               (= (:status res) 200))
        (callback (:body res))
        (callback [nil res]))))
  nil)


(defn pull-one!
  [& {:keys [url name params callback options]
      :or   {params  {}
             options {}}}]
  (cond
    (not (keyword? name))
    (callback [nil "Name will be keyword"])
    (not (map? params))
    (callback [nil "Param will be map "])
    (not (map? options))
    (callback [nil "Option will be map "])
    :else
    (-> (build-request name params options)
        (call-http-service (str url "/pullone") callback))))


(defn pull-batch!
  [& {:keys [url name params callback options]
      :or   {params  {}
             options {}}}]
  (if-let [e (error? name params options)]
    (callback e)
    (-> (build-request name params options)
        (call-http-service (str url "/pullbatch") callback))))




(defn push-one!
  [& {:keys [url name params callback options]
      :or   {options {}}}]
  (cond
    (not (keyword? name))
    (callback [nil "Name will be keyword"])
    (not (map? params))
    (callback [nil "Param will be map "])
    (not (map? options))
    (callback [nil "Option will be map "])
    :else
    (-> (build-request name params options)
        (call-http-service (str url "/pushone") callback))))


(defn push-batch!
  [& {:keys [url name params callback options]
      :or   {options {}}}]
  (if-let [e (error? name params options)]
    (callback e)
    (-> (build-request name params options)
        (call-http-service (str url "/pushbatch") callback))))


(defn skip-model-name
  [w]
  (let [[v e] w]
    (if e
      w
      [(first (vals v)) nil])))





(defn js-pull-one
  [url-str name params callback]
  (let [namev (keyword (js->clj name))
        params (js->clj params)
        cb (fn [res] (callback (clj->js res)))]
    (pull-one! :url url-str
               :name namev
               :params params
               :options {:input  :string
                         :output :string}
               :callback cb)
    nil))

(defn js-pull-batch
  [url-str name params callback]
  (let [namev (mapv keyword (js->clj name))
        params (js->clj params)
        cb (fn [res] (callback (clj->js res)))]
    (pull-batch! :url url-str
                 :name namev
                 :params params
                 :options {:input  :string
                           :output :string}
                 :callback cb)
    nil))

(defn js-push-one
  [url-str name params callback]
  (let [namev (keyword (js->clj name))
        params (js->clj params)
        cb (fn [res] (callback (clj->js res)))]
    (push-one! :url url-str
               :name namev
               :options {:input  :string
                         :output :string}
               :params params
               :callback cb)
    nil))


(defn js-push-batch
  [url-str name params callback]
  (let [namev (mapv keyword (js->clj name))
        params (js->clj params)
        cb (fn [res] (callback (clj->js res)))]
    (push-batch! :url url-str
                 :name namev
                 :options {:input  :string
                           :output :string}
                 :params params
                 :callback cb)
    nil))



(comment

  )
