(ns tiesql.view
  (:require [json-html.core :as jh]))


(defn table-view [t-heading t-data]
  [:div.panel.panel-default
   [:div.panel-heading (str t-heading)]
   [:div.panel-body
    [:div.table-responsive
     [:table.table.table-bordered
      [:thead
       (for [h (first t-data)]
         [:th (str h)])]
      [:tbody
       (for [r (rest t-data)]
         [:tr
          (for [c r]
            [:td (str c)])])]]]]])


(defn warp-edn-view
  [handler]
  (fn [[OK ERROR]]
    (handler
      (if OK
        [:div (jh/edn->hiccup OK)]
        [:div (jh/edn->hiccup ERROR)]))))


(defn warp-table-views
  [handler]
  (fn [[OK ERROR]]
    (handler
      (if OK
        [:div (map (fn [[k v]]
                     [:div (table-view k v)]
                     ) OK)]
        [:div (jh/edn->hiccup ERROR)]))))
