(ns tiesql.client
  (:import [goog.net EventType ErrorCode XhrIo]
           [goog.net Jsonp])
  (:require [cljs-http.client :as http]
            [cljs.core.async :as async :refer [chan close!]])
  (:require-macros [cljs.core.async.macros :refer [go alt!]]))


(defn log [s]
  (.log js/console (str s)))


(defn build-request
  [name-coll params-map]
  (let [v {:name   name-coll
           :params params-map}]
    {:with-credentials? false
     :accept            "application/transit+json"
     ;:accept            "application/edn"
     :transit-params    v}))


(defn call-http-service
  [url-str name-coll params-map callback]
  (cond
    (not (sequential? name-coll))
    (callback [nil "Name will be sequential"])
    (not (map? params-map))
    (callback [nil "Param will be map "])
    :else
    (go
      (let [res (->> (build-request name-coll params-map)
                     (http/post url-str)
                     (async/<!))]
        (if (and (:success res)
                 (= (:status res) 200))
          (callback (:body res))
          (callback [nil res]))))))


(defn read!
  [& {:keys [url name params callback]
      :or   {params {}}}]
  (call-http-service (str url "/read") name params callback))



(defn write!
  [& {:keys [url name params callback]}]
  (call-http-service (str url "/write") name params callback))



;(execute "/tie" [:insert-dept] {:department {:dept_name "Call Center 8"}} log )





#_(defn ^:export query
    [url-str name name-params handler]
    (query-impl url-str name name-params handler))



#_(defn ^:export execute
    [url-str name name-params]
    (execute-impl url-str name name-params))



#_(go
    (->>
      (execute-impl "/tie" [:insert-dept] {:department {:dept_name "Call Center 8"}})
      (async/<!)
      ;(:body)
      (.log js/console)))





;(.log js/console "he")

;(println "hsdf")






;(query :url "/tie" :name [:get-dept-by-id] :params {:id 1} :callback log)




(comment

  )
