(ns tiesql.client
  (:require [clj-http.client :as client]
            [clojure.tools.reader.edn :as edn]))


(defn make-request
  [name-coll params]
  (let [v {:name   name-coll
           :params params}]
    {:form-params  v
     :as           :transit+json
     ;:accept        :edn
     :accept       :transit+json
     :content-type :transit+json}))


(defn call-http-service
  [url name-coll params]
  (cond
    (not (sequential? name-coll))
    [nil "Name will be sequential"]
    (not (map? params))
    [nil "Param will be map"]
    :else
    (let [res (->> (make-request name-coll params)
                   (client/post url))]
      (if (= (:status res)
             200)
        (:body res)
        [nil res]))))


(defn read!
  [& {:keys [url name params]
      :or   {params {}}}]
  (call-http-service (str url "/read") name params))


(defn write!
  [& {:keys [url name params]}]
  (call-http-service (str url "/write") name params))




