(ns tiesql.client
  (:require [clj-http.client :as client]
            [clojure.tools.reader.edn :as edn]))


(defn make-request
  [name-coll params]
  (let [v {:name   name-coll
           :params params}]
    {:form-params  v
     :as           :transit+json
     ;:accept        :edn
     :accept       :transit+json
     :content-type :transit+json}))


(defn call-http-service
  [url name-coll params]
  (cond
    (not (sequential? name-coll))
    [nil "Name will be sequential"]
    (not (map? params))
    [nil "Param will be map"]
    :else
    (let [res (->> (make-request name-coll params)
                   (client/post url))]
      (if (= (:status res)
             200)
        (:body res)
        [nil res]))))


(defn read!
  [& {:keys [url name params]
      :or   {params {}}}]
  (call-http-service (str url "/read") name params))


(defn write!
  [& {:keys [url name params]}]
  (call-http-service (str url "/write") name params))




(comment


  (->> (read! :url "http://localhost:3000/tie"
              :name [:get-dept-by-id]
              :params {:id 1})
       (clojure.pprint/pprint))


  (->> {:department {:dept_name "Call Center 8"}}
       (write! "http://localhost:3000/tie" [:insert-dept]))

  (->> (make-request [:insert-dept] {:department {:dept_name "Call Center 8"}})
       (client/post "http://localhost:3000/tie/execute")
       (:body)
       (edn/read-string)
       (clojure.pprint/pprint))


  (->> {:employee
        [{:firstname "Abdul",
          :lastname  "Rahim",
          :dept_id   1}
         {:firstname "Chu",
          :lastname  "Nio",
          :dept_id   1}]}
       (make-request [:insert-employee])
       (client/post "http://localhost:3000/tie/execute")
       (:body)
       (edn/read-string)
       (clojure.pprint/pprint))

  )